<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Transaction Receipt</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #ffffff;
                color: #333;
            }

            .container {
                max-width: 800px;
                margin: 20px auto;
                padding: 20px;
                border: 1px solid #dddddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            }

            header {
                text-align: center;
                margin-bottom: 20px;
            }

            .logo {
                max-width: 150px;
                margin-bottom: 10px;
            }

            h1 {
                font-size: 24px;
                margin-bottom: 10px;
            }

            h2 {
                font-size: 20px;
                margin-bottom: 10px;
            }

            table {
                width: 100%;
                border-collapse: collapse;
                margin-bottom: 20px;
            }

            table,
            th,
            td {
                border: 1px solid #ddd;
            }

            th,
            td {
                padding: 12px;
                text-align: left;
            }

            th {
                background-color: #f5f5f5;
                color: #333;
            }

            .status {
                font-weight: bold;
            }

            .status-completed {
                color: #28a745;
                /* Green */
            }

            .status-pending {
                color: #ffc107;
                /* Yellow */
            }

            .status-failed {
                color: #dc3545;
                /* Red */
            }

            p {
                line-height: 1.6;
                margin-bottom: 10px;
            }

            footer {
                text-align: center;
                font-size: 0.9em;
                color: #333;
            }
        </style>
    </head>

    <body>
        <div class="container">
            <header>
                <img src="<?php echo e(public_path('/uploads/logo/' . @$settings->site_logo)); ?>" alt="Company Logo" class="logo">
            </header>

            <section class="transaction-details">
                <h2>Transaction Details</h2>
                <table>
                    <tr>
                        <th>Transaction ID</th>
                        <td><?php echo e($transaction->reference_id); ?></td>
                    </tr>
                    <tr>
                        <th>Description</th>
                        <td><?php echo e($transaction->description); ?></td>
                    </tr>
                    <tr>
                        <th>Amount</th>
                        <td><?php echo e(formatAmount($transaction->amount, 'symbol', $user->id)); ?></td>
                    </tr>
                    <tr>
                        <th>Date</th>
                        <td><?php echo e(date('dS M Y', strtotime($transaction->transaction_date))); ?>

                            <?php echo e(date('g:i A', strtotime($transaction->transaction_time))); ?></td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td class="status-<?php echo e($transaction->status == 'SUCCESSFUL' ? 'completed' : 'failed'); ?>">
                            <?php echo e(ucfirst($transaction->status)); ?>

                        </td>
                    </tr>
                </table>
            </section>

            <footer>
                <p>Thank you for using <?php echo e(config('app.name')); ?>!</p>
            </footer>
        </div>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/pdf/transaction.blade.php ENDPATH**/ ?>