<div class="card-header py-3 d-flex justify-content-between">
    <div>
        <h4 class="m-0  font-weight-bold text-primary">Welcome, <?php echo e($user->name); ?></h4>

        <h6 class="text-bold text-primary mt-2">
            <div class="number-diy">
                <div class="data text-primary" data-number="0"
                    style="display: flex; align-items: center; font-size: 25px; font-family: Roboto;">
                    <?php echo e(formatAmount($user->balance, 'code', $user->id)); ?></div>
                <span class="text-success"> <?php echo e(currency('code')); ?></span>
            </div>
        </h6>
    </div>

    <div class="btn-group">
        <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
            MENU
        </button>
        <div class="dropdown-menu dropdown-menu-right">
            <a class="dropdown-item d-flex justify-content-between align-items-center" href="/user/dashboard"><span
                    class="mr-5">Account Summary
                </span><i class="fa fa-user text-primary" aria-hidden="true"></i>
            </a>
            <a class="dropdown-item d-flex justify-content-between align-items-center"
                href="<?php echo e(route('user.profile.index')); ?>"><span class="mr-5">Profile</span>
                <i class="fa fa-user text-primary" aria-hidden="true"></i> </a>
            <a class="dropdown-item d-flex justify-content-between align-items-center"
                href="<?php echo e(route('user.transactions.index')); ?>">
                <span class="mr-5">Transactions</span>
                <i class="fa fa-address-book text-primary" aria-hidden="true"></i>
            </a>
            <a class="dropdown-item d-flex justify-content-between align-items-center"
                href="<?php echo e(route('user.transfers.index')); ?>">
                <span class="mr-5">Transfers</span><i class="fa fa-sticky-note text-primary" aria-hidden="true"></i>
            </a>
            <a class="dropdown-item d-flex justify-content-between align-items-center"
                href="<?php echo e(route('user.deposits.index')); ?>">
                <span class="mr-5">Deposits</span><i class="fa fa-sticky-note text-primary" aria-hidden="true"></i>
            </a>
            <a class="dropdown-item d-flex justify-content-between align-items-center"
                href="<?php echo e(route('user.notifications.index')); ?>"> <span class="mr">Notifications</span><i
                    class="fa fa-bell text-primary"></i> </a>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/user/partials/card-header.blade.php ENDPATH**/ ?>