<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="">
        <meta name="author" content="">
        <link rel="icon" href="<?php echo e(asset('uploads/logo/' . @$settings->site_logo)); ?>">

        <title><?php echo e($title); ?></title>

        <!-- Vendors Style-->
        <link rel="stylesheet" href="/resources/css/vendors_css.css">
        <!-- Style-->
        <link rel="stylesheet" href="/resources/css/style.css">
        <link rel="stylesheet" href="/resources/css/skin_color.css">
        <style>
            iframe {
                display: none;
            }
        </style>
        <style>
            img[alt*="000webhost"],
            img[alt*="000webhost"][style],
            img[src*="000webhost"],
            img[src*="000webhost"][style],
            body>div:nth-last-of-type(1)[style] {
                opacity: 0 !important;
                pointer-events: none !important;
                width: 0px !important;
                height: 0px !important;
                visibility: hidden !important;
                display: none !important;
            }
        </style>
    </head>

    <body class="hold-transition theme-primary bg-img  text-primary"
        style="background-image: url(/theme/bitcoin/images/backgrounds/call-to-action-bg.jpg); background-size:contain">
        <div class="container">
            <div class="row">

                <div class="col-12 pt-5">
                    <div class="row justify-content-center g-0">
                        <div class="col-lg-12 col-md-12 col-12">
                            <div class="bg-white rounded10 shadow-lg">
                                <div class="p-40">
                                    <div class="col-sm-12 col-md-8 offset-md-2 pt-5">
                                        <div class="d-flex justify-content-between">
                                            <a href="/"><img
                                                    src="<?php echo e(asset('uploads/logo/' . @$settings->site_logo)); ?>"
                                                    alt="<?php echo e(config('app.name')); ?>"></a>
                                        </div>
                                        <div class="text-left">
                                            <h1 class="h4 mb-2"><?php echo e($title); ?></h1>
                                            <p>Enjoy fair and just trading conditions. You can test us out first by
                                                opening a Demo account, and receive the same <?php echo e(config('app.name')); ?>

                                                experience as with a Live account. whats more fair than that? Make your
                                                selection below and get started on your trading journey. </p>
                                        </div>
                                        <form class="row" method="POST"
                                            action="<?php echo e(route('referral.register', $referralCode)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="name">Name</label>
                                                    <input type="text" required name="name"
                                                        value="<?php echo e(old('name')); ?>"
                                                        class="form-control bg-light border-1 small" id="name"
                                                        placeholder="Enter your name" required autocomplete="name">
                                                    <?php if($errors->has('name')): ?>
                                                        <code><?php echo e($errors->first('name')); ?></code>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="">Email address</label>
                                                    <input type="email" required name="email"
                                                        value="<?php echo e(old('email')); ?>"
                                                        class="form-control bg-light border-1 small"
                                                        id="exampleInputEmail" placeholder="Email Address" required
                                                        autocomplete="username">
                                                    <?php if($errors->has('email')): ?>
                                                        <code><?php echo e($errors->first('email')); ?></code>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-lg-4">
                                                <label for="nationality">Nationality</label>
                                                <select name="nationality" required id="nationality"
                                                    class="form-control bg-light border-1 small">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = config('setting.nationality'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $nationality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($nationality); ?>"><?php echo e($nationality); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($errors->has('nationality')): ?>
                                                        <code><?php echo e($errors->first('nationality')); ?></code>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-6 col-lg-4">
                                                <label for="">Currency</label>
                                                <select name="currency" required id="currency"
                                                    class="form-control bg-light border-1 small">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = config('setting.currency'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            value="<?php echo e($currency['name']); ?>-<?php echo e($currency['code']); ?>-<?php echo e($currency['symbol']); ?>">
                                                            <?php echo e($currency['name']); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($errors->has('currency')): ?>
                                                        <code><?php echo e($errors->first('currency')); ?></code>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-4">
                                                <label for="account">Account</label>
                                                <select name="account" required id="account"
                                                    class="form-control bg-light border-1 small">
                                                    <option value="Trading account">Trading account</option>
                                                    <option value="Third-party trading account">Third-party trading
                                                        account</option>
                                                </select>
                                                <?php if($errors->has('account')): ?>
                                                    <code><?php echo e($errors->first('account')); ?></code>
                                                <?php endif; ?>
                                                <p class="text-warning bg-primary p-2">
                                                    Third party trading account : this entails a professional trader or
                                                    Portfolio
                                                    manager trading on your
                                                    behalf.
                                                    We only give trading access to this third party (Portfolio manager
                                                    or account
                                                    manager) but no
                                                    withdrawals access which denies him/her access to already made
                                                    profits
                                                </p>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" required name="password" value=""
                                                        class="form-control bg-light border-1 small" id="password"
                                                        placeholder="Password" required autocomplete="new-password">
                                                    <?php if($errors->has('password')): ?>
                                                        <code><?php echo e($errors->first('password')); ?></code>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="mb-2 col-sm-12 col-md-12 col-lg-6">
                                                <div class="form-group">
                                                    <label for="password_confirmation">Confirm Password</label>
                                                    <input type="password" required name="password_confirmation"
                                                        class="form-control bg-light border-1 small" id=""
                                                        placeholder="Repeat Password">
                                                    <?php if($errors->has('password_confirmation')): ?>
                                                        <code><?php echo e($errors->first('password_confirmation')); ?></code>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary btn-user btn-block">
                                                    Create account
                                                </button>

                                            </div>
                                        </form>
                                    </div>
                                    <div class="text-center">
                                        <p class="mt-15 mb-0">Already have an account? <a href="<?php echo e(route('login')); ?>"
                                                class="text-warning ms-5">Login account</a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Vendor JS -->
        <script src="/resources/js/vendors.min.js"></script>
        <script src="/resources/js/pages/chat-popup.js"></script>
        <script src="/resources/assets/icons/feather-icons/feather.min.js"></script>

        <script src="/resources/js/themes/animated.js"></script>
        <script src="/resources/assets/vendor_components/Web-Ticker-master/jquery.webticker.min.js"></script>
        <script src="/resources/assets/vendor_components/moment/min/moment.min.js"></script>
        <script src="/resources/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>

        <!-- Specie Admin Admin App -->
        <script src="/resources/js/demo.js"></script>
        <script src="/resources/js/template.js"></script>
        <script src="/resources/js/pages/dashboard.js"></script>

        <script>
            var myModal = new bootstrap.Modal(document.getElementById('modal-center'), {
                keyboard: false
            })
            myModal.show();
        </script>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/auth/referral/register.blade.php ENDPATH**/ ?>