<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header d-none d-md-block d-lg-block">
        <div class="d-flex align-items-center">
            <div class="me-auto">
                <h4 class="page-title">My account</h4>
                <div class="d-inline-block align-items-center">
                    <nav>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#"><i class="fa fa-home" aria-hidden="true"></i></a></li>
                            <li class="breadcrumb-item" aria-current="page"><?php echo e($user->name); ?>

                            </li>
                        </ol>
                    </nav>
                </div>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <h2><?php echo e($user->name); ?></h2>
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="row">
                    <div class="col-sm-12 col-md-10">
                        <!-- menu, date & IP -->
                        <div class="d-flex align-items-center">
                            <div class="rounded-3 p-2  mr-2">
                                <i class="fas fa-box text-white"></i>
                            </div>

                            <!-- ip & date -->
                            <div class="ms-2 fw-bold text-success">
                                <span> LOGIN IP: <?php echo e(request()->ip()); ?> </span>
                                <span> Date: <?php echo e(date('d M Y')); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-2 d-none d-md-block d-lg-block">
                        <!-- user details at top right -->
                        <div class="d-flex justify-content-center">
                            <?php if($user->image == 'profile.png'): ?>
                                <img style="width: 15%; height:auto; border-radius:5px; border:2px solid gray; overflow:hidden;"
                                    src="<?php echo e(asset('resources/images/' . $user->image)); ?>" alt="Profile">
                            <?php else: ?>
                                <img style="width: 15%; height:auto; border-radius:5px; border:2px solid gray; overflow:hidden;"
                                    src="<?php echo e(asset('uploads/users/images/' . $user->image)); ?>" alt="Profile">
                            <?php endif; ?>

                            <div class="ml-2">
                                <span class=" fw-bold cap">
                                    <?php echo e($user->name); ?> </span> <br>
                                <span class="cap"> <?php echo e($user->account); ?> </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row my-4">
                    <!-- contains balance and history -->
                    <!-- balance card -->
                    <div class="col-12 col-md-7 bg-black p-3">
                        <div class="d-flex justify-content-between">
                            <div class="text-white"> <span>Available Balance</span> </div>
                        </div>

                        <!-- account balance -->
                        <div>
                            <i class="text-white fa fa-wallet fa-3x"></i>
                            <span class="text-white balance fw-bold"><?php echo e(currency('code')); ?>

                                <?php echo e(formatAmount($user->balance, 'code', $user->id)); ?> </span>
                        </div>

                        <!-- progress bar below account balance -->
                        <div>
                            <progress max="100" value="100" class="w-100 progress"></progress>
                        </div>

                        <div class="row mb-3">
                            <div class="col-sm-12 col-md-3">
                                <a href="<?php echo e(route('user.profile.index')); ?>" role="button">
                                    <!-- FALSE -->
                                    <div class="d-flex justify-content-between align-items-center align-contents-center"
                                        style="width:80px; height:80px; border:2px solid transparent; overflow:hidden; object-fit: cover; ">
                                        <?php if($user->image == 'profile.png'): ?>
                                            <img style="width: 100%;" src="<?php echo e(asset('resources/images/' . $user->image)); ?>"
                                                alt="Profile">
                                        <?php else: ?>
                                            <img style="width: 100%;"
                                                src="<?php echo e(asset('uploads/users/images/' . $user->image)); ?>" alt="Profile">
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                            <div class="col-sm-12 col-md-6">
                                <!-- account details -->
                                <div class="d-flex justify-content-between mt-4">
                                    <div class="">
                                        <div class="upper text-white opacity-50">Account holder</div>
                                        <div class="cap text-white ">
                                            <?php echo e($user->name); ?> </div>
                                    </div>
                                    <div class="">
                                        <div class="upper text-white opacity-50">Account Type</div>
                                        <div class="cap text-white "><?php echo e($user->account); ?></div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between mt-2">
                                    <div>
                                        <div class="upper text-white opacity-50">Account State</div>
                                        <div class="cap text-white">
                                            <?php if($user->status == 1): ?>
                                                ACTIVE
                                            <?php else: ?>
                                                INACTIVE
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- send & deposit money buttons -->
                        <div class="d-flex mt-5 justify-content-between">
                            <a href="<?php echo e(route('user.transfer')); ?>" class="send-button btn btn-secondary  d-flex">
                                <div class="icon-holder ">
                                    <i class="text-black fa fa-hand-holding-usd"></i>

                                </div>
                                <span class="text-white align-self-center p-2 ">
                                    Withdraw
                                </span>
                            </a>
                            <a href="<?php echo e(route('user.deposits.index')); ?>"
                                class=" ms-1 deposit-button btn btn-primary d-flex">
                                <div class="icon-holder ">
                                    <i class="cap text-black fa fa-piggy-bank"></i>
                                </div>
                                <span class="cap text-white align-self-center p-2 ">
                                    Make Deposit
                                </span>
                            </a>
                        </div>

                    </div>
                    <div class="col-12 col-md-5 ">
                        <!-- transaction history -->
                        <div class="rounded-5 mt-4 ">

                            <div class="d-block d-md-flex justify-content-between">
                                <div class="mb-2">
                                    <div>
                                        <i class="text-success fa fa-warehouse fa-2x"></i>
                                        <span class="text-center fs-4 cap text-success fw-bold">
                                            latest transactions </span>
                                    </div>
                                    <div>
                                        <small> below is the recent transaction occurred on your
                                            account
                                        </small>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <a href="<?php echo e(route('user.transactions.show',$transaction->id)); ?>"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <span
                                                class="badge <?php echo e($transaction->transaction_type == 'CREDIT' ? 'badge-success' : 'badge-danger'); ?> float-right"><?php echo e($transaction->transaction_type); ?></span>
                                            <h5 class="m-0 p-0"><span
                                                    class="<?php echo e($transaction->transaction_type == 'CREDIT' ? 'text-success' : 'text-danger'); ?>"><?php echo e(formatAmount($transaction->amount, 'code', $user->id)); ?></span>
                                                <small><?php echo e(currency('name')); ?></small>
                                            </h5>
                                            <p class="m-0 p-0"><?php echo e($transaction->description); ?></p>
                                            <p class="text-primary">Balance:
                                                <?php echo e(formatAmount($transaction->current_balance, 'code', $user->id)); ?></p>
                                            <small class="float-right">
                                                Date: <?php echo e(date('dS M, Y', strtotime($transaction->transaction_date))); ?>

                                            </small>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="card-body scroll-card-body">
                                            <div class="alert alert-warning" role="alert">
                                                <strong>No transactions yet</strong>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="fs-3 fw-bold text-center">Transactions</div>
                                <div class="d-flex justify-content-between mt-4">
                                    <a class="text-center" href="<?php echo e(route('user.transfers.index')); ?>">
                                        <div><i class="fa fa-money-bill fa-4x"></i></div>
                                        <div> History</div>
                                    </a>
                                    <a href="<?php echo e(route('user.transfer')); ?>" class="text-center">
                                        <div><i class="fa fa-exchange-alt fa-4x"></i></div>
                                        <div> Send Money</div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6 ">
                        <div class="card">
                            <div class="card-body">
                                <div class="fs-2 text-center fw-bold">Transfers</div>
                                <div class="d-flex justify-content-between mt-5">
                                    <a class="text-center" href="<?php echo e(route('user.transfer')); ?>s">
                                        <div><i class="fa fa-history fa-3x"></i></div>
                                        <div class="mt-3">Transfer History</div>
                                    </a>
                                    <div class="text-center">
                                        <div class="fw-bold"><i class="fa fa-circle-notch fa-3x"></i>
                                        </div>
                                        <div>0 Total Transfers</div>
                                        <div class="mt-3 text-primary">Last updated: <?php echo e(date('M dS Y')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-sm-12 col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="text-center fw-bold fs-1">Profile </div>
                                <div class="d-flex justify-content-between mt-5">
                                    <a href="<?php echo e(route('user.notifications.index')); ?>" class="text-center">
                                        <div>
                                            <div><i class="fa fa-coins fa-5x"></i></div>
                                            <div class="text-center">Notifications</div>
                                        </div>
                                    </a>
                                    <a href="<?php echo e(route('user.profile.index')); ?>">
                                        <div><i class="fa fa-cog fa-5x"></i></div>
                                        <div class="text-center">Settings</div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/user/index.blade.php ENDPATH**/ ?>