<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.admin.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <div class="card-header py-3 d-flex justify-content-between">
                        <div>
                            <h4 class="m-0  font-weight-bold text-primary"><?php echo e($title); ?></h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                <?php $__empty_1 = true; $__currentLoopData = $planCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="list-group">
                                        <a href="#"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <h5 class="m-0 p-0 d-flex justify-content-between">
                                                <span><?php echo e($planCategory->name); ?></span>
                                                <small><?php echo e(adminFormatAmount($settings, $planCategory->price)); ?></small>
                                            </h5>
                                        </a>
                                        <div class="btn-group">
                                            <a href="<?php echo e(route('admin.plans.index', $planCategory->slug)); ?>"
                                                class="btn text-white btn-warning btn-sm">ADD PLAN
                                                <i class="fa fa-plus" aria-hidden="true"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.plan-categories.edit', $planCategory->id)); ?>"
                                                class="btn text-white btn-primary btn-sm">EDIT
                                                <i class="fa fa-edit" aria-hidden="true"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.plan-categories.delete', $planCategory->id)); ?>"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE <i class="fa fa-trash"
                                                    aria-hidden="true"></i> </a>
                                        </div>
                                        <hr>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="alert alert-warning" role="alert">
                                        <strong>No plan categories yet</strong>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            <?php echo $__env->make('partials.validation-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('partials.email-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="card">

                                <div class="card-header">
                                    <h5>Create plan category</h5>
                                </div>
                                <div class="card-body">
                                    <form action="<?php echo e(route('admin.plan-categories.update', $planCategory->id)); ?>"
                                        method="POST" class="row">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('put'); ?>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label for="name">Name </label>
                                                <input type="text" name="name" id="name"
                                                    value="<?php echo e($planCategory->name); ?>" class="form-control"
                                                    placeholder="Enter plan category name" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label for="price">Price </label>
                                                <input type="text" name="price" id="price"
                                                    value="<?php echo e($planCategory->price); ?>" class="form-control"
                                                    placeholder="Enter plan category price" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">UPDATE</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/admin/plan-category/edit.blade.php ENDPATH**/ ?>