<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.admin.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary"><?php echo e($title); ?></h6>
            </div>
            <div class="card-body">
                <div class="list-group d-lg-none">
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('admin.users.profile.index', $user->id)); ?>"
                            class="list-group-item list-group-item-action flex-column align-items-start">
                            <div class="d-flex w-100 justify-content-between">
                                <h5 class="mb-1"><?php echo e($user->name); ?></h5>
                                <small>
                                    <?php if($user->status == 0): ?>
                                        <i class="fa fa-times-circle text-danger" aria-hidden="true"></i>
                                    <?php else: ?>
                                        <i class="fa fa-check-circle text-success" aria-hidden="true"></i>
                                    <?php endif; ?>
                                </small>
                            </div>
                            <p class="mb-1">Email: <?php echo e($user->email); ?></p>
                            <small>Registered: <?php echo e(date('dS M Y', strtotime($user->created_at))); ?></small>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
                <div class="d-none d-lg-block">
                    <table class="table" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="30%">Name</th>
                                <th width="30%">Email</th>
                                <th width="5%">Email status</th>
                                <th width="5%">Account state</th>
                                <th width="30%">Registered</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('admin.users.profile.index', $user->id)); ?>"
                                            class="list-group-item-action text-primary">
                                            <?php echo e($user->name); ?></a>
                                    </td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td>
                                        <?php if($user->email_verified_at == null): ?>
                                            <i class="fa fa-times-circle text-danger" aria-hidden="true"></i>
                                        <?php else: ?>
                                            <i class="fa fa-check-circle text-success" aria-hidden="true"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($user->status == 0): ?>
                                            <i class="fa fa-times-circle text-danger" aria-hidden="true"></i>
                                        <?php else: ?>
                                            <i class="fa fa-check-circle text-success" aria-hidden="true"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td> <?php echo e(date('dS M Y', strtotime($user->created_at))); ?><br>
                                        <span class="text-danger">Last
                                            login:</span><?php echo e(date('dS M Y  g:i:s A', strtotime($user->last_login_time))); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Email status</th>
                                <th>Account state</th>
                                <th>Registered</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/admin/user/verified.blade.php ENDPATH**/ ?>