<div class="card-header py-3 d-flex justify-content-between">
    <div>
        <h4 class="m-0  font-weight-bold text-primary"><?php echo e($user->name); ?></h4>

        <h6 class="text-bold text-primary mt-2">
            <div class="number-diy">
                <div class="data text-primary" data-number="0"
                    style="display: flex; align-items: center; font-size: 25px; font-family: Roboto;">
                    <?php echo e(formatAmount($user->balance, 'code', $user->id)); ?></div>
                <span class="text-success"> <?php echo e(currency('code', $user->id)); ?></span>
            </div>
        </h6>
    </div>

    <div>
        <div class="btn-group">
            <button class="btn btn-sm btn-danger dropdown-toggle" type="button" data-bs-toggle="dropdown"><i
                    class="icon ti-settings"></i>ACCOUNT OPTIONS</button>
            <div class="dropdown-menu dropdown-menu-end">
                <a class="dropdown-item d-flex justify-content-between"
                    href="<?php echo e(route('admin.users.profile.index', $user->id)); ?>">
                    View Profile </a>
                <a class="dropdown-item d-flex justify-content-between"
                    href="<?php echo e(route('admin.users.transactions.index', $user->id)); ?>">
                    Fund Account</a>
                <a class="dropdown-item d-flex justify-content-between"
                    href="<?php echo e(route('admin.users.withdrawals.index', $user->id)); ?>">
                    View Withdrawals</a>
                <a class="dropdown-item d-flex justify-content-between"
                    href="<?php echo e(route('admin.users.deposits.index', $user->id)); ?>">
                    Deposits</a>
                <a class="dropdown-item d-flex justify-content-between"
                    href="<?php echo e(route('admin.users.plans.index', $user->id)); ?>">
                    Plans</a>
                <a class="dropdown-item d-flex justify-content-between"
                    href="<?php echo e(route('admin.users.notifications.index', $user->id)); ?>">
                    View Notifications </a>

            </div>
        </div>

        <div class="btn-group">
            <button class="btn btn-sm btn-info dropdown-toggle" type="button" data-bs-toggle="dropdown">
                STATUS</button>
            <div class="dropdown-menu dropdown-menu-end">
                <?php if($user->email_verified_at == null): ?>
                    <a class="dropdown-item" href="<?php echo e(route('admin.users.skip-verification', $user->id)); ?>">Skip
                        verification</a>
                <?php else: ?>
                    <a class="dropdown-item" href="<?php echo e(route('admin.users.set-verification', $user->id)); ?>">Set
                        verification</a>
                <?php endif; ?>
                <a class="dropdown-item" href="<?php echo e(route('admin.users.account-settings.index', $user->id)); ?>">Account
                    setting</a>
                <a class="dropdown-item delete-item" onclick="return confirm('Are you sure?')"
                    href="<?php echo e(route('admin.users.delete', $user->id)); ?>">Delete
                    account</a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/admin/partials/card-header.blade.php ENDPATH**/ ?>