<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.admin.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <?php echo $__env->make('dashboard.admin.partials.card-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="list-group">
                                        <a href="#"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <h5 class="m-0 p-0 d-flex justify-content-between">
                                                <?php if($transaction->transaction_type == 'CREDIT'): ?>
                                                    <span
                                                        class="text-success"><?php echo e(formatAmount($transaction->amount, 'code', $user->id)); ?></span>
                                                <?php elseif($transaction->transaction_type == 'DEBIT'): ?>
                                                    <span
                                                        class="text-danger"><?php echo e(formatAmount($transaction->amount, 'code', $user->id)); ?></span>
                                                <?php endif; ?>
                                                <small><?php echo e($transaction->currency); ?></small>

                                                <?php if($transaction->transaction_type == 'CREDIT'): ?>
                                                    <span class="badge badge-success float-right">CREDIT</span>
                                                <?php elseif($transaction->transaction_type == 'DEBIT'): ?>
                                                    <span class="badge badge-danger float-right">DEBIT</span>
                                                <?php endif; ?>
                                            </h5>
                                            <p class="m-0 p-0"><?php echo e($transaction->description); ?></p>
                                            <small>Balance:
                                                <?php echo e(formatAmount($transaction->current_balance, 'code', $user->id)); ?></small>
                                            <small class="float-right">
                                                Date: <?php echo e(date('dS M, Y', strtotime($transaction->transaction_date))); ?>

                                            </small>
                                        </a>
                                        <div class="btn-group">
                                            <?php if(@$settings->pdf_status == 'enabled'): ?>
                                                <a href="<?php echo e(route('admin.users.transactions.print', [$user->id, $transaction->id])); ?>"
                                                    class="btn text-white btn-primary btn-sm" target="_blank">PRINT <i
                                                        class="fa fa-print" aria-hidden="true"></i>
                                                </a>
                                            <?php endif; ?>
                                            <a href="<?php echo e(route('admin.users.transactions.delete', $transaction->id)); ?>"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE <i class="fa fa-trash"
                                                    aria-hidden="true"></i> </a>
                                        </div>
                                        <hr>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="alert alert-warning" role="alert">
                                        <strong>No transactions yet</strong>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            <?php echo $__env->make('partials.validation-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('partials.email-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="card">

                                <div class="card-header">
                                    <h5>Send Transaction</h5>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="mt-0 mb-0 col-sm-4">Account name:</dt>
                                        <dd class="mt-0 mb-0 col-sm-8"><?= $user->name ?></dd>
                                        <dt class="mt-0 mb-0 col-sm-4">Account balance:</dt>
                                        <dd class="mt-0 mb-0 col-sm-8">
                                            <strong><?php echo e(formatAmount($user->balance, 'code', $user->id)); ?></strong>
                                            -
                                            <?php echo e(currency('name', $user->id)); ?>

                                        </dd>
                                    </dl>
                                    <small id="helpId" class="text-danger">Do not use: spaces or comma, use only numbers
                                        when
                                        entering amount</small>
                                    <form action="<?php echo e(route('admin.users.transactions.store', $user->id)); ?>" method="POST"
                                        class="row">
                                        <?php echo csrf_field(); ?>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Amount </label>
                                                <input type="text" name="amount" id="" required=""
                                                    value="" class="form-control" placeholder=""
                                                    aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Type </label>
                                                <select name="type" id="" class="form-control" required="">
                                                    <option value=""></option>
                                                    <option value="DEBIT">DEBIT</option>
                                                    <option value="CREDIT">CREDIT</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Date</label>
                                                <input type="date" name="date" id="" required=""
                                                    class="form-control" placeholder="" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Notification </label>
                                                <select name="notification" id="" class="form-control"
                                                    required="">
                                                    <option value=""></option>
                                                    <option value="NONE">NONE</option>
                                                    <option value="EMAIL">EMAIL</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label for="">Description</label>
                                                <input type="text" name="description" required="" id=""
                                                    class="form-control" placeholder="" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">SUBMIT</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/admin/user/transaction/index.blade.php ENDPATH**/ ?>