<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.admin.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <div class="card-header py-3 d-flex justify-content-between">
                        <div>
                            <h4 class="m-0  font-weight-bold text-primary"><?php echo e($title); ?></h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                <?php $__empty_1 = true; $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="list-group">
                                        <a href="#"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <h5 class="m-0 p-0 d-flex justify-content-between">
                                                <span><?php echo e($wallet->name); ?></span>
                                                <small><?php echo e($wallet->address); ?></small>
                                                <?php if($wallet->status == 1): ?>
                                                    <span class="badge badge-success float-right">Active</span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger float-right">Inactive</span>
                                                <?php endif; ?>
                                            </h5>
                                            <p class="m-0 p-0">

                                            </p>
                                        </a>
                                        <div class="btn-group">
                                            <a href="<?php echo e(route('admin.wallets.show', $wallet->id)); ?>"
                                                class="btn text-white btn-warning btn-sm">VIEW
                                                <i class="fa fa-eye" aria-hidden="true"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.wallets.edit', $wallet->id)); ?>"
                                                class="btn text-white btn-primary btn-sm">EDIT
                                                <i class="fa fa-edit" aria-hidden="true"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.wallets.delete', $wallet->id)); ?>"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE <i class="fa fa-trash"
                                                    aria-hidden="true"></i> </a>
                                        </div>
                                        <hr>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="alert alert-warning" role="alert">
                                        <strong>No wallets yet</strong>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            <?php echo $__env->make('partials.validation-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('partials.email-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="card">

                                <div class="card-header">
                                    <h5>Create wallet</h5>
                                </div>
                                <div class="card-body">
                                    <small id="helpId" class="text-danger">This wallet will be used by the user for
                                        deposit.</small>
                                    <form action="<?php echo e(route('admin.wallets.store')); ?>" method="POST" class="row"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="name">Name </label>
                                                <input type="text" name="name" id="name"
                                                    value="<?php echo e(old('name')); ?>" class="form-control"
                                                    placeholder="Enter wallet name" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="acronyms">Acronyms </label>
                                                <input type="text" name="acronyms" id="acronyms"
                                                    value="<?php echo e(old('acronyms')); ?>" class="form-control"
                                                    placeholder="Enter wallet acronyms" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="address">Address </label>
                                                <input type="text" name="address" id="address"
                                                    value="<?php echo e(old('address')); ?>" class="form-control"
                                                    placeholder="Enter wallet address" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="logo">Logo </label>
                                                <input type="file" name="logo" id="logo" class="form-control"
                                                    aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="qr_code">Qr code </label>
                                                <input type="file" name="qr_code" id="qr_code" class="form-control"
                                                    aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="status">Status </label>
                                                <select name="status" id="status" class="form-control" required>
                                                    <option value="">Select status of the wallet</option>
                                                    <option value="1">Active</option>
                                                    <option value="0">Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">SUBMIT</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/admin/wallet/index.blade.php ENDPATH**/ ?>