<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                margin: 0
            }

            .container {
                width: 100%;
                margin: 0 auto;
            }
        </style>
    </head>

    <body>

        <?php if($emailData['type'] == 'CREDIT'): ?>
            <div class="container">
                <p>Dear <?php echo e($user->name); ?>,</p>
                <p>We've received your deposit of <?php echo e(formatAmount($emailData['amount'], 'code', $user->id)); ?>. Your
                    account has been credited
                    accordingly.</p>
                <p>Thank you for using our services.</p>
                <p>Sincerely,</p>
                <p><?php echo e(config('app.name')); ?> Service.</p>
            </div>
        <?php else: ?>
            <div class="container">
                <p>Dear <?php echo e($user->name); ?>,</p>
                <p>Your withdrawal request of <?php echo e(formatAmount($emailData['amount'], 'code', $user->id)); ?> has been
                    processed. Your account has been
                    credited
                    accordingly.</p>
                <p>Thank you for using our services.</p>
                <p>Sincerely,</p>
                <p><?php echo e(config('app.name')); ?> Service.</p>
            </div>
        <?php endif; ?>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/emails/transaction.blade.php ENDPATH**/ ?>