<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.admin.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <div class="card-header py-3 d-flex justify-content-between">
                        <div>
                            <h4 class="m-0  font-weight-bold text-primary"><?php echo e($title); ?></h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-8">
                            <ul class="list-group">
                                <?php $__empty_1 = true; $__currentLoopData = $verificationCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="list-group-item mb-2">
                                        <h5 class="d-flex justify-content-between"> <?php echo e($code->name); ?> <div
                                                class="dropdown open">
                                                <button class="btn btn-primary btn-sm dropdown-toggle" type="button"
                                                    data-bs-toggle="dropdown">
                                                    <i class="fa fa-cog" aria-hidden="true"></i> Actions
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="triggerId">
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('admin.verification-codes.edit', $code->id)); ?>">Edit
                                                    </a>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('admin.verification-codes.delete', $code->id)); ?>"
                                                        onclick="return confirm('Are you sure?')">Delete
                                                        code</a>
                                                </div>
                                            </div>
                                        </h5>
                                        <p>Applicable for:
                                            <?php if($code->applicable_to == 'All'): ?>
                                                <?php echo e($code->applicable_to); ?> users
                                            <?php else: ?>
                                                <?php echo e($code->user->name); ?>

                                            <?php endif; ?>
                                        </p>
                                        <small>Nature : <?php echo e($code->length); ?> <span
                                                class="text-capitalize"><?php echo e($code->nature_of_code); ?></span> code</small>
                                        <span class="badge badge-primary float-right"><?php echo e($code->created_at); ?></span>

                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="alert alert-warning">No verification code registered</div>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <form action="<?php echo e(route('admin.verification-codes.update', $verificationCode->id)); ?>"
                                class="row" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('patch'); ?>
                                <div class="col-xs-12 col-md-12">
                                    <?php echo $__env->make('partials.validation-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <h4>Edit verification code</h4>
                                    <div class="form-group">
                                        <label for="">Name</label>
                                        <input type="text" name="name" id="name" class="form-control"
                                            value="<?php echo e($verificationCode->name); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label for="">Description</label>
                                        <input type="text" name="description" class="form-control"
                                            value="<?php echo e($verificationCode->description); ?>">
                                        <small>What this code is all about</small>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Length</label>
                                        <input type="number" name="length" value="<?php echo e($verificationCode->length); ?>"
                                            class="form-control">
                                        <small>How long do you want this code to be when generated?</small>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Nature of code</label>
                                        <select name="nature_of_code" class="form-control">
                                            <option value="alnum"
                                                <?php echo e($verificationCode->nature_of_code == 'alnum' ? 'selected' : ''); ?>>
                                                Alphanumeric</option>
                                            <option value="numeric"
                                                <?php echo e($verificationCode->nature_of_code == 'numeric' ? 'selected' : ''); ?>>
                                                Numeric</option>
                                        </select>
                                        <small>Do you want this code to be a mixture of letters and numbers(alpha-numeric)?
                                            or
                                            just
                                            numbers(numeric)</small>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Applicable to user</label>
                                        <select name="applicable_to" class="form-control">
                                            <option <?php echo e($verificationCode->applicable_to == 'All' ? 'selected' : ''); ?>

                                                value="All">
                                                ALL USERS</option>
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    <?php echo e($verificationCode->applicable_to == $user->id ? 'selected' : ''); ?>

                                                    value="<?php echo e($user->id); ?>">
                                                    <?php echo e($user->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button class="btn btn-primary btn-sm" type="submit">
                                            UPDATE
                                        </button>
                                        <button class="btn btn-warning btn-sm" type="reset">
                                            RESET
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/admin/verification-code/edit.blade.php ENDPATH**/ ?>