<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.user.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <?php echo $__env->make('dashboard.user.partials.card-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-header">
                                <h4><?php echo e($title); ?></h4>
                                <p>Transfer history</p>
                            </div>
                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    <?php $__empty_1 = true; $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transfer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <a href="<?php if($transfer->status == 0): ?> <?php echo e(route('user.transfer.preview', $transfer->reference_id)); ?>

                                        <?php else: ?>
                                        <?php echo e(route('user.transfer.show', $transfer->reference_id)); ?> <?php endif; ?>"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <?php if($transfer->status == 0): ?>
                                                <span class="badge badge-danger float-right">PENDING</span>
                                            <?php elseif($transfer->status == 1): ?>
                                                <span class="badge badge-success float-right">APPROVED</span>
                                            <?php elseif($transfer->status == 2): ?>
                                                <span class="badge badge-danger float-right">FAILED</span>
                                            <?php endif; ?>
                                            <h5 class="m-0 p-0"><span
                                                    class=""><?php echo e(formatAmount($transfer->amount, 'code')); ?></span>
                                                <small><?php echo e(currency('name')); ?></small>
                                            </h5>
                                            <p class="m-0 p-0"><?php echo e($transfer->transfer_type); ?></p>
                                            <small class="float-right">
                                                Date: <?php echo e(date('dS M,Y', strtotime($transfer->created_at))); ?> </small>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="alert alert-warning" role="alert">
                                            <strong>No transfers yet</strong>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php echo $__env->make('dashboard.user.partials.card-footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            <?php echo $__env->make('dashboard.user.partials.personal-account-details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/user/transfer/index.blade.php ENDPATH**/ ?>