<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.user.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="shadow mb-4 border-bottom-success">
                    <?php echo $__env->make('dashboard.user.partials.card-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-header">
                                <h4>User transactions</h4>
                                <p>Transaction history</p>
                            </div>

                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <a href="<?php echo e(route('user.transactions.show', $transaction->id)); ?>"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <span
                                                class="badge <?php echo e($transaction->transaction_type == 'CREDIT' ? 'badge-success' : 'badge-danger'); ?> float-right"><?php echo e($transaction->transaction_type); ?></span>
                                            <h5 class="m-0 p-0"><span
                                                    class="<?php echo e($transaction->transaction_type == 'CREDIT' ? 'text-success' : 'text-danger'); ?>"><?php echo e(formatAmount($transaction->amount, 'code', $user->id)); ?></span>
                                                <small><?php echo e(currency('name')); ?></small>
                                            </h5>
                                            <p class="m-0 p-0"><?php echo e($transaction->description); ?></p>
                                            <p class="text-primary">Balance:
                                                <?php echo e(formatAmount($transaction->current_balance, 'code', $user->id)); ?></p>
                                            <small class="float-right">
                                                Date: <?php echo e(date('dS M, Y', strtotime($transaction->transaction_date))); ?>

                                            </small>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="card-body scroll-card-body">
                                            <div class="alert alert-warning" role="alert">
                                                <strong>No transactions yet</strong>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <?php echo $__env->make('dashboard.user.partials.card-footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            <?php echo $__env->make('dashboard.user.partials.personal-account-details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/user/transaction/index.blade.php ENDPATH**/ ?>