<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <?php echo $__env->make('dashboard.user.partials.content-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <?php echo $__env->make('dashboard.user.partials.card-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="card-header">
                                <h4>Deposit funds</h4>
                                <p>Select one of the options to deposit funds to your account</p>
                            </div>
                            <div class="card-body">
                                <div class="row">

                                    <div class="col-sm-12 col-md-5">
                                        <h4>Deposit via:</h4>
                                        <div class="row">
                                            <?php $__empty_1 = true; $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <div class="col-6">
                                                    <a href="<?php echo e(route('user.deposits.show', $wallet->acronyms)); ?>"><img
                                                            src="<?php echo e(asset('uploads/wallets/logos/' . $wallet->logo)); ?>"
                                                            alt="" class="img-fluid w-75">
                                                        <p><?php echo e($wallet->name); ?></p>
                                                    </a>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <div class="alert alert-warning col-12" role="alert">
                                                    No wallet available yet
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 col-md-7 scroll-card-body">
                                        <h5>Deposit history</h5>
                                        <ul class="list-group">
                                            <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <a href="#"
                                                    class="list-group-item list-group-item-action <?php echo e($deposit->status != 1 ? 'text-danger' : 'text-success'); ?>">
                                                    <span
                                                        class="badge <?php echo e($deposit->status != 1 ? 'bg-danger' : 'bg-success'); ?> text-white float-right"><?php echo e($deposit->status != 1 ? 'PENDING' : 'CONFIRMED'); ?></span>
                                                    <h5 class="m-0 p-0">
                                                        <span
                                                            class="<?php echo e($deposit->status != 1 ? 'text-danger' : 'text-success'); ?> ">
                                                            <?php echo e(formatAmount($deposit->amount, 'code', $user->id)); ?>

                                                            <small><?php echo e(currency('name', $user->id)); ?></small>
                                                    </h5>
                                                    <p class="m-0 p-0">
                                                        Deposited with <?php echo e($deposit->method); ?> <br>
                                                        Transaction ID: <?php echo e($deposit->reference_id); ?> </p>
                                                    <small class="float-right">
                                                        Date: <?php echo e(date('dS M,Y', strtotime($deposit->created_at))); ?>

                                                    </small>
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <div class="col-sm-12 col-md-7 scroll-card-body">
                                                    <div class="alert alert-warning" role="alert">
                                                        No deposit record found
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php echo $__env->make('dashboard.user.partials.card-footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/user/deposit/index.blade.php ENDPATH**/ ?>