<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="section-header">
            <h1><?php echo e($title); ?></h1>
        </div>
        <div class="row">
            <div class="col-12">
                <?php echo $__env->make('partials.validation-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="card border">
                    <div class="card-body">
                        <form action="<?php echo e(route('master.general-settings.update', 1)); ?>" method="post"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('put'); ?>
                            <div class="form-group">
                                <label for="site_name">Site Name</label>
                                <input id="site_name" type="text" class="form-control" name="site_name"
                                    value="<?php echo e(@$generalSetting->site_name); ?>">
                            </div>
                            <div class="form-group">
                                <label for="site_status">Site Status</label>
                                <select name="site_status" id="site_status" class="form-control">
                                    <option value="">Select</option>
                                    <option value="disabled"
                                        <?php echo e(@$generalSetting->site_status == 'disabled' ? 'selected' : ''); ?>>
                                        Disabled
                                    </option>
                                    <option value="enabled"
                                        <?php echo e(@$generalSetting->site_status == 'enabled' ? 'selected' : ''); ?>>
                                        Enabled
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="pdf_status">Pdf Status</label>
                                <select name="pdf_status" id="pdf_status" class="form-control">
                                    <option value="">Select</option>
                                    <option value="disabled"
                                        <?php echo e(@$generalSetting->pdf_status == 'disabled' ? 'selected' : ''); ?>>
                                        Disabled
                                    </option>
                                    <option value="enabled"
                                        <?php echo e(@$generalSetting->pdf_status == 'enabled' ? 'selected' : ''); ?>>
                                        Enabled
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="contact_email">Contact Email</label>
                                <input type="email" name="contact_email" id="contact_email" class="form-control"
                                    value="<?php echo e(@$generalSetting->contact_email); ?>">
                            </div>
                            <div class="form-group">
                                <label for="contact_phone">Contact Phone</label>
                                <input type="phone" name="contact_phone" id="contact_phone" class="form-control"
                                    value="<?php echo e(@$generalSetting->contact_phone); ?>">
                            </div>
                            <div class="form-group">
                                <label for="contact_address">Contact Address</label>
                                <input type="address" name="contact_address" id="contact_address" class="form-control"
                                    value="<?php echo e(@$generalSetting->contact_address); ?>">
                            </div>
                            <div class="form-group">
                                <label for="currency_name">Currency Name</label>
                                <select name="currency_name" id="currency_name" class="form-control select2">
                                    <option value="">Select</option>
                                    <?php $__currentLoopData = config('setting.currency'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($currency['name']); ?>"
                                            <?php echo e($currency['name'] == @$generalSetting->currency_name ? 'selected' : ''); ?>>
                                            <?php echo e($currency['name']); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="currency_icon">Currency Icon</label>
                                <select name="currency_icon" id="currency_icon" class="form-control select2">
                                    <option value="">Select</option>
                                    <?php $__currentLoopData = config('setting.currency'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($currency['symbol']); ?>"
                                            <?php echo e($currency['symbol'] == @$generalSetting->currency_icon ? 'selected' : ''); ?>>
                                            <?php echo e($currency['name']); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="timezone">Time Zone</label>
                                <select name="timezone" id="timezone" class="form-control select2">
                                    <option value="">Select</option>
                                    <?php $__currentLoopData = config('setting.timezone'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"
                                            <?php echo e($key == @$generalSetting->timezone ? 'selected' : ''); ?>><?php echo e($key); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="site_environment">Site Environment</label>
                                <select name="site_environment" id="site_environment" class="form-control">
                                    <option value="">Select</option>
                                    <option value="local"
                                        <?php echo e(@$generalSetting->site_environment == 'local' ? 'selected' : ''); ?>>Local
                                    </option>
                                    <option value="production"
                                        <?php echo e(@$generalSetting->site_environment == 'production' ? 'selected' : ''); ?>>
                                        Production
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="site_debug">Site Debug</label>
                                <select name="site_debug" id="site_debug" class="form-control">
                                    <option value="">Select</option>
                                    <option value="1" <?php echo e(@$generalSetting->site_debug == 1 ? 'selected' : ''); ?>>True
                                    </option>
                                    <option value="0" <?php echo e(@$generalSetting->site_debug == 0 ? 'selected' : ''); ?>>False
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="site_url">Site Url</label>
                                <input type="address" name="site_url" id="site_url" class="form-control"
                                    value="<?php echo e(@$generalSetting->site_url); ?>">
                            </div>
                            <div class="form-group">
                                <label for="site_logo">Site Logo</label>
                                <input type="file" name="site_logo" id="site_logo" class="form-control">
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.master.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/dashboard/master/general-setting/index.blade.php ENDPATH**/ ?>