
<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f5f5f5;
            }

            .email-container {
                max-width: 600px;
                margin: 20px auto;
                background-color: #ffffff;
                border: 1px solid #dddddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                overflow: hidden;
            }

            .header {
                background-color: #003366;
                color: #ffffff;
                padding: 20px;
                text-align: center;
            }

            .header img {
                max-width: 150px;
                margin-bottom: 10px;
            }

            .header h1 {
                margin: 0;
                font-size: 24px;
            }

            .content {
                padding: 20px;
            }

            .content h2 {
                color: #003366;
                font-size: 20px;
                margin-bottom: 10px;
            }

            .content p {
                color: #333333;
                line-height: 1.6;
                margin-bottom: 10px;
            }

            .button {
                display: inline-block;
                padding: 10px 20px;
                background-color: #003366;
                color: #ffffff;
                text-decoration: none;
                border-radius: 5px;
                margin-top: 10px;
            }

            .footer {
                background-color: #f5f5f5;
                color: #333333;
                padding: 10px;
                text-align: center;
                font-size: 0.9em;
                border-top: 1px solid #dddddd;
            }

            .footer a {
                color: #003366;
                text-decoration: none;
            }
        </style>
    </head>

    <body>
        <div class="email-container">
            <div class="header">
                <img src="<?php echo e(asset('uploads/logo/' . @$settings->site_logo)); ?>" alt="<?php echo e(config('app.name')); ?> Logo">
            </div>
            <div class="content">
                <h1> Hi <?php echo e($user->name); ?></h1>
                <br>
                <p><b> Here is your email confirmation code:</b></p>
                <h2 style='color:blue'> <?php echo e($content['code']); ?></h2> </br>
                <span> Simply use this code on <?php echo e(config('app.name')); ?> to confirm your email address </br>
                    If you did not try to register using this email on <?php echo e(config('app.name')); ?>, please ignore this
                    message</span>
                <p>Thank you for choosing our services!</p>
                <p>Sincerely,<br>The <?php echo e(config('app.name')); ?> Team</p>
            </div>
            <div class="footer">
                <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
            </div>
        </div>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\broker-v2.0\resources\views/email/verification.blade.php ENDPATH**/ ?>