<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\Dashboard\Admin\UserController;
use App\Http\Controllers\Dashboard\User\WalletController;
use App\Http\Controllers\Dashboard\Master\AdminController;
use App\Http\Controllers\Dashboard\User\DepositController;
use App\Http\Controllers\Dashboard\User\ProfileController;
use App\Http\Controllers\Dashboard\User\TransferController;
use App\Http\Controllers\Dashboard\User\DashboardController;
use App\Http\Controllers\Dashboard\User\PlanController;
use App\Http\Controllers\Dashboard\User\TradeViewController;
use App\Http\Controllers\Dashboard\Admin\AdminPlanController;
use App\Http\Controllers\Dashboard\User\LinkAccountController;
use App\Http\Controllers\Dashboard\User\TransactionController;
use App\Http\Controllers\Dashboard\Admin\AdminWalletController;
use App\Http\Controllers\Dashboard\Admin\UserDepositController;
use App\Http\Controllers\Dashboard\Admin\UserProfileController;
use App\Http\Controllers\Dashboard\User\NotificationController;
use App\Http\Controllers\Dashboard\User\ReferralCodeController;
use App\Http\Controllers\Dashboard\User\VerificationController;
use App\Http\Controllers\Dashboard\Master\EmailSettingController;
use App\Http\Controllers\Dashboard\Admin\AdminDashboardController;
use App\Http\Controllers\Dashboard\Admin\UserWithdrawalController;
use App\Http\Controllers\Dashboard\Admin\UserTransactionController;
use App\Http\Controllers\Dashboard\Master\GeneralSettingController;
use App\Http\Controllers\Dashboard\Admin\UserNotificationController;
use App\Http\Controllers\Dashboard\Master\MasterDashboardController;
use App\Http\Controllers\Dashboard\Admin\AdminPlanCategoryController;
use App\Http\Controllers\Dashboard\User\DirectBankTransferController;
use App\Http\Controllers\Dashboard\User\ElectronicTransferController;
use App\Http\Controllers\Dashboard\Admin\UserAccountSettingController;
use App\Http\Controllers\Dashboard\User\ValidateTransferCodeController;
use App\Http\Controllers\Dashboard\Admin\AdminVerificationCodeController;
use App\Http\Controllers\Dashboard\Admin\UserPlanController;

Route::get('/', HomeController::class)->name('home');

Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/contact', [PageController::class, 'contact'])->name('contact');
Route::get('/affiliate', [PageController::class, 'affiliate'])->name('affiliate');
Route::get('/faq', [PageController::class, 'faq'])->name('faq');
Route::get('/terms', [PageController::class, 'terms'])->name('terms');

require __DIR__ . '/auth.php';

Route::middleware(['auth', 'role:user'])->prefix('user')->name('user.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    // Verification controller routes
    Route::get('/verification', [VerificationController::class, 'verification'])->name('verification');
    Route::get('/resend-verification', [VerificationController::class, 'resendVerification'])->name('resend-verification');
    Route::post('/verify', [VerificationController::class, 'verify'])->name('verify');
    // Trade view controller routes
    Route::get('/trade-view', [TradeViewController::class, 'index'])->name('trade-view.index');
    // Profile controller routes
    Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
    Route::patch('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
    Route::patch('/profile-image/update', [ProfileController::class, 'imageUpdate'])->name('profile-image.update');
    // Transaction controller routes
    Route::get('/transactions/print/{id}', [TransactionController::class, 'print'])->name('transactions.print');
    Route::resource('/transactions', TransactionController::class);
    // Wallet controller routes
    Route::resource('/wallets', WalletController::class);
    // Transfer controller routes
    Route::get('/transfers', [TransferController::class, 'index'])->name('transfers.index');
    Route::get('/transfer', [TransferController::class, 'transfer'])->name('transfer');
    Route::get('/transfer/{referenceId}/preview', [TransferController::class, 'preview'])->name('transfer.preview');
    Route::get('/transfer/{referenceId}/confirm', [TransferController::class, 'confirm'])->name('transfer.confirm');
    Route::get('/transfer/{referenceId}/order/{orderNo}/process', [TransferController::class, 'process'])->name('transfer.process');
    Route::post('/transfer/{referenceId}/order/{orderNo}/code/validate', [ValidateTransferCodeController::class, 'store'])->name('transfer.code.validate');
    Route::get('/transfer/{referenceId}', [TransferController::class, 'show'])->name('transfer.show');
    Route::get('/transfer/{referenceId}/print', [TransferController::class, 'print'])->name('transfer.print');
    // Deposit controller routes
    Route::get('/deposits', [DepositController::class, 'index'])->name('deposits.index');
    Route::get('/deposits/{acronyms}', [DepositController::class, 'show'])->name('deposits.show');
    Route::post('/deposits/{id}', [DepositController::class, 'store'])->name('deposits.store');
    // Link account controller routes
    Route::resource('/link-account', LinkAccountController::class);
    // Notification controller routes
    Route::resource('/notifications', NotificationController::class);
    // Referral link controller routes
    Route::get('/referral-codes/store', [ReferralCodeController::class, 'store'])->name('referral-codes.store');
    // Direct bank transfer controller routes
    Route::post('/direct-bank-transfer', [DirectBankTransferController::class, 'store'])->name('direct-bank-transfer');
    // Electronic transfer controller routes
    Route::post('/electronic-transfer', [ElectronicTransferController::class, 'store'])->name('electronic-transfer');
    // Plan controller routes
    Route::get('/plans', [PlanController::class, 'index'])->name('plans.index');
    Route::get('/plans/{planCategorySlug}/payment/method', [PlanController::class, 'paymentMethod'])->name('plans.payment.method');
    Route::get('/plans/{planCategorySlug}/payment/method/{walletAcronyms}/details', [PlanController::class, 'paymentMethodDetails'])->name('plans.payment.method.details');
    Route::post('/plans/{planCategorySlug}/payment/method/{walletAcronyms}/store', [PlanController::class, 'paymentMethodStore'])->name('plans.payment.method.store');
});
Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    // User controller route
    Route::get('/users/verified', [UserController::class, 'verified'])->name('verified.users');
    Route::get('/users/unverified', [UserController::class, 'unverified'])->name('unverified.users');
    Route::get('/users/set-verification/{id}', [UserController::class, 'setVerification'])->name('users.set-verification');
    Route::get('/users/skip-verification/{id}', [UserController::class, 'skipVerification'])->name('users.skip-verification');
    Route::get('/users/delete/{id}', [UserController::class, 'destroy'])->name('users.delete');
    //  User profile controller routes
    Route::get('/users/{id}/profile', [UserProfileController::class, 'index'])->name('users.profile.index');
    Route::patch('/users/{id}profile/update', [UserProfileController::class, 'update'])->name('users.profile.update');
    Route::patch('/users/{id}/profile/image/update', [UserProfileController::class, 'imageUpdate'])->name('users.profile.image.update');
    // User Account setting controller routes
    Route::get('/users/{id}/account-settings', [UserAccountSettingController::class, 'index'])->name('users.account-settings.index');
    Route::put('/users/{id}/account-settings/update', [UserAccountSettingController::class, 'update'])->name('users.account-settings.update');
    // User Transaction controller routes
    Route::get('/users/{id}/transactions', [UserTransactionController::class, 'index'])->name('users.transactions.index');
    Route::post('/users/{id}/transactions/store', [UserTransactionController::class, 'store'])->name('users.transactions.store');
    Route::get('/users/{id}/transactions/{transactionId}/print', [UserTransactionController::class, 'print'])->name('users.transactions.print');
    Route::get('/users/transactions/{transactionId}/delete', [UserTransactionController::class, 'delete'])->name('users.transactions.delete');
    // User notification controller routes
    Route::get('/users/{id}/notifications', [UserNotificationController::class, 'index'])->name('users.notifications.index');
    Route::post('/users/{id}/notifications/store', [UserNotificationController::class, 'store'])->name('users.notifications.store');
    Route::get('/users/notifications/{notificationId}/delete', [UserNotificationController::class, 'delete'])->name('users.notifications.delete');
    // Wallet controller routes
    Route::get('/wallets/{id}/delete', [AdminWalletController::class, 'delete'])->name('wallets.delete');
    Route::resource('/wallets', AdminWalletController::class);
    // User deposit controller routes
    Route::get('/users/{id}/deposits', [UserDepositController::class, 'index'])->name('users.deposits.index');
    Route::get('/users/{id}/deposits/{depositId}', [UserDepositController::class, 'show'])->name('users.deposits.show');
    Route::get('/users/{id}/deposits/{depositId}/confirm', [UserDepositController::class, 'confirm'])->name('users.deposits.confirm');
    Route::get('/users/deposits/{depositId}/delete', [UserDepositController::class, 'delete'])->name('users.deposits.delete');
    // Verification code controller routes
    Route::get('/verification-codes/{id}/delete', [AdminVerificationCodeController::class, 'delete'])->name('verification-codes.delete');
    Route::resource('/verification-codes', AdminVerificationCodeController::class);
    // User withdrawal controller routes
    Route::get('/users/{id}/withdrawals', [UserWithdrawalController::class, 'index'])->name('users.withdrawals.index');
    Route::get('/users/{id}/withdrawals/{referenceId}', [UserWithdrawalController::class, 'show'])->name('users.withdrawals.show');
    Route::get('/users/withdrawals/{id}/delete', [UserWithdrawalController::class, 'delete'])->name('users.withdrawals.delete');
    // Plan category controller routes
    Route::get('/plan-categories/{id}/delete', [AdminPlanCategoryController::class, 'delete'])->name('plan-categories.delete');
    Route::resource('/plan-categories', AdminPlanCategoryController::class);
    // Plan controller routes
    Route::get('/{planCategorySlug}/plans', [AdminPlanController::class, 'index'])->name('plans.index');
    Route::get('/{planCategorySlug}/plans/create', [AdminPlanController::class, 'create'])->name('plans.create');
    Route::post('/{planCategorySlug}/plans/store', [AdminPlanController::class, 'store'])->name('plans.store');
    Route::get('/plans/{id}/edit', [AdminPlanController::class, 'edit'])->name('plans.edit');
    Route::patch('/plans/{id}/update', [AdminPlanController::class, 'update'])->name('plans.update');
    Route::get('/plans/{id}/delete', [AdminPlanController::class, 'delete'])->name('plans.delete');
    // User plan controller routes
    Route::get('/users/{id}/plans', [UserPlanController::class, 'index'])->name('users.plans.index');
    Route::get('/users/{id}/plans/{plan}', [UserPlanController::class, 'show'])->name('users.plans.show');
    Route::get('/users/{id}/plans/{plan}/confirm', [UserPlanController::class, 'confirm'])->name('users.plans.confirm');
    Route::post('/users/{id}/plans/{plan}/confirm/store', [UserPlanController::class, 'confirmStore'])->name('users.plans.confirm.store');
    Route::get('/users/plans/{plan}/delete', [UserPlanController::class, 'delete'])->name('users.plans.delete');
});

Route::middleware(['auth', 'role:master'])->prefix('master')->name('master.')->group(function () {
    Route::get('/dashboard', [MasterDashboardController::class, 'index'])->name('dashboard');
    Route::resource('/email-settings', EmailSettingController::class);
    Route::resource('/general-settings', GeneralSettingController::class);
    Route::resource('/admins', AdminController::class);
});
