<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f5f5f5;
            }

            .email-container {
                max-width: 600px;
                margin: 20px auto;
                background-color: #ffffff;
                border: 1px solid #dddddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                overflow: hidden;
            }

            .header {
                background-color: #003366;
                color: #ffffff;
                padding: 20px;
                text-align: center;
            }

            .header img {
                max-width: 150px;
                margin-bottom: 10px;
            }

            .header h1 {
                margin: 0;
                font-size: 24px;
            }

            .content {
                padding: 20px;
            }

            .content h2 {
                color: #003366;
                font-size: 20px;
                margin-bottom: 10px;
            }

            .content p {
                color: #333333;
                line-height: 1.6;
                margin-bottom: 10px;
            }

            .button {
                display: inline-block;
                padding: 10px 20px;
                background-color: #003366;
                color: #ffffff;
                text-decoration: none;
                border-radius: 5px;
                margin-top: 10px;
            }

            .footer {
                background-color: #f5f5f5;
                color: #333333;
                padding: 10px;
                text-align: center;
                font-size: 0.9em;
                border-top: 1px solid #dddddd;
            }

            .footer a {
                color: #003366;
                text-decoration: none;
            }
        </style>
    </head>

    <body>
        <div class="email-container">
            <div class="header">
                <img src="{{ asset('uploads/logo/' . @$settings->site_logo) }}" alt="{{ config('app.name') }} Logo">
            </div>
            <div class="content">
                <h2>Dear {{ $user->name }},</h2>
                <p>We are thrilled to have you on board. At {{ config('app.name') }}, we are committed to providing you
                    with the
                    best investment services and support to help you achieve your financial goals.</p>
                <p>Your account has been successfully created, and you can now start exploring our platform and take
                    advantage of our comprehensive range of services.</p>
                <p>To get started, please verify your email address and activate your account:
                </p>
                <p>If you have any questions or need assistance, please do not hesitate to contact our support team at
                    <a href="mailto:{{ config('app.email') }}">{{ config('app.name') }}</a>.
                </p>
                <p>Thank you for choosing {{ config('app.name') }}. We look forward to helping you achieve your
                    investment goals.
                </p>
                <p>Sincerely,<br>The {{ config('app.name') }} Team</p>
            </div>
            <div class="footer">
                <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
            </div>
        </div>
    </body>

</html>
