@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card  mb-4 border-left-success ">
                    @include('dashboard.user.partials.card-header')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-12 col-md-8">
                                <!-- Content Row -->
                                <div class="row">
                                    <!-- Earnings (Monthly) Card Example -->
                                    <div class="col-md-6 mb-4">
                                        <div class="card border-left-primary shadow h-100 py-2">
                                            <div class="card-body">
                                                <div class="row no-gutters align-items-center">
                                                    <div class="col mr-2">
                                                        <div
                                                            class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                            Balance
                                                        </div>
                                                        <div class="h5 mb-0 font-weight-bold">
                                                            {{ currency('code') }}
                                                            {{ formatAmount($user->balance, 'code', $user->id) }} <div
                                                                class="counter">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <i class="fas fa-money-bill-alt    "></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Earnings (Monthly) Card Example -->
                                    <div class="col-md-6 mb-4">
                                        <div class="card border-left-success shadow h-100 py-2">
                                            <div class="card-body">
                                                <div class="row no-gutters align-items-center">
                                                    <div class="col mr-2">
                                                        <div
                                                            class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                            Earnings</div>
                                                        <div class="h5 mb-0 font-weight-bold">
                                                            {{ formatAmount($user->earning, null, $user->id) }}
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <i class="fas fa-dollar-sign fa-2x"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Earnings (Monthly) Card Example -->
                                    <div class="col-md-6 mb-4">
                                        <div class="card border-left-info shadow h-100 py-2">
                                            <div class="card-body">
                                                <div class="row no-gutters align-items-center">
                                                    <div class="col mr-2">
                                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                            Account state
                                                        </div>
                                                        <div class="row no-gutters align-items-center">
                                                            <div class="h5 mb-0 mr-3 font-weight-bold">
                                                                @if ($user->status == 1)
                                                                    Active
                                                                @else
                                                                    Inactive
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <i class="fas fa-clipboard-list fa-2x"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="box">
                                    <div class="box-header">
                                        <ul class="nav nav-tabs customtab nav-justified" role="tablist">
                                            <li class="nav-item"> <a class="nav-link active" data-bs-toggle="tab"
                                                    href="#messages" role="tab">Recent transactions </a> </li>
                                            <li class="nav-item"> <a class="nav-link" data-bs-toggle="tab" href="#contacts"
                                                    role="tab">Recent Withdrawals</a> </li>
                                        </ul>
                                    </div>
                                    <div class="box-body">
                                        <!-- Tab panes -->
                                        <div class="tab-content">
                                            <div class="tab-pane active" id="messages" role="tabpanel">
                                                <div class="slimScrollDiv"
                                                    style="position: relative; overflow: hidden; width: auto; height: 685px;">
                                                    <div class="chat-box-one-side3"
                                                        style="overflow: hidden; width: auto; height: 685px;">

                                                        @forelse ($transactions as $transaction)
                                                            <a
                                                                href="{{ route('user.transactions.show', $transaction->id) }}">
                                                                <div class="d-flex justify-content-between">
                                                                    <div class="d-flex flex-2 description">
                                                                        <i class="{{ $transaction->transaction_type == 'CREDIT' ? 'fa fa-arrow-up' : 'fa fa-arrow-down' }}"
                                                                            aria-hidden="true"></i>
                                                                        <div class="mx-2">
                                                                            <strong
                                                                                class="badge {{ $transaction->transaction_type == 'CREDIT' ? 'badge-success' : 'badge-danger' }}">{{ $transaction->transaction_type }}</strong>
                                                                            <small
                                                                                class="d-block">{{ $transaction->description }}</small>
                                                                            <small class="d-block">Balance:
                                                                                {{ formatAmount($transaction->current_balance, 'code', $user->id) }}</small>
                                                                        </div>
                                                                    </div>
                                                                    <div class="date">
                                                                        <strong>
                                                                            Date:
                                                                            {{ date('dS M,Y', strtotime($transaction->transaction_date)) }}</strong>
                                                                    </div>
                                                                </div>
                                                            </a>
                                                            <div class="divider"></div>
                                                        @empty
                                                            <div class="media-list media-list-hover">
                                                                <div class="alert alert-info" role="alert">
                                                                    <strong>No recent transaction made yet</strong>
                                                                </div>
                                                            </div>
                                                        @endforelse

                                                    </div>
                                                    <div class="slimScrollBar"
                                                        style="background: rgb(0, 0, 0); width: 7px; position: absolute; top: 0px; opacity: 0.1; display: none; border-radius: 7px; z-index: 99; right: 1px; height: 685px;">
                                                    </div>
                                                    <div class="slimScrollRail"
                                                        style="width: 7px; height: 100%; position: absolute; top: 0px; display: none; border-radius: 7px; background: rgb(51, 51, 51); opacity: 0.2; z-index: 90; right: 1px;">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="contacts" role="tabpanel">
                                                <div class="slimScrollDiv"
                                                    style="position: relative; overflow: hidden; width: auto; height: 685px;">
                                                    <div class="chat-box-one-side3"
                                                        style="overflow: hidden; width: auto; height: 685px;">

                                                        <div class="media-list media-list-hover">
                                                            @forelse ($transfers as $transfer)
                                                                <a
                                                                    href="@if ($transfer->status == 0) {{ route('user.transfer.preview', $transfer->reference_id) }}
                                                                    @else
                                                                    {{ route('user.transfer.show', $transfer->reference_id) }} @endif">
                                                                    <div class="d-flex justify-content-between">
                                                                        <div class="d-flex flex-2 description">
                                                                            <i class="fa {{ $transfer->status == 0 ? 'fa-times' : 'fa-check' }} "
                                                                                aria-hidden="true"></i>
                                                                            <div class="mx-2">

                                                                                @if ($transfer->status == 0)
                                                                                    <strong
                                                                                        class="badge badge-danger">PENDING</strong>
                                                                                @elseif($transfer->status == 1)
                                                                                    <strong
                                                                                        class="badge badge-success">APPROVED</strong>
                                                                                @elseif($transfer->status == 2)
                                                                                    <strong
                                                                                        class="badge badge-danger">FAILED</strong>
                                                                                @endif
                                                                                <small
                                                                                    class="d-block">{{ $transfer->type }}</small>
                                                                                <small class="d-block">Amount:
                                                                                    {{ formatAmount($transfer->amount, 'code') }}</small>
                                                                            </div>
                                                                        </div>
                                                                        <div class="date">
                                                                            <strong>
                                                                                Date:
                                                                                {{ date('dS M,Y', strtotime($transfer->created_at)) }}
                                                                            </strong>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                            @empty
                                                                <div class="media-list media-list-hover">
                                                                    <div class="alert alert-info" role="alert">
                                                                        <strong>No withdrawal made yet</strong>
                                                                    </div>
                                                                </div>
                                                            @endforelse

                                                        </div>
                                                    </div>
                                                    <div class="slimScrollBar"
                                                        style="background: rgb(0, 0, 0); width: 7px; position: absolute; top: 0px; opacity: 0.1; display: block; border-radius: 7px; z-index: 99; right: 1px;">
                                                    </div>
                                                    <div class="slimScrollRail"
                                                        style="width: 7px; height: 100%; position: absolute; top: 0px; display: none; border-radius: 7px; background: rgb(51, 51, 51); opacity: 0.2; z-index: 90; right: 1px;">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-4">
                                @include('dashboard.user.partials.personal-account-details')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
