@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            @include('partials.validation-message')
                            @include('partials.email-message')
                            <div class="card-header flex-column align-items-left">
                                <h4>Transfer details</h4>
                            </div>
                            <div class="card-body">
                                @if ($transfer->status == 0)
                                    <span class="badge badge-danger float-right">PENDING</span>
                                @elseif($transfer->status == 1)
                                    <span class="badge badge-success float-right">APPROVED</span>
                                @elseif($transfer->status == 2)
                                    <span class="badge badge-danger float-right">FAILED</span>
                                @endif
                                <h5 class="m-0 p-0"><span
                                        class="text-primary">{{ formatAmount($transfer->amount, 'code') }}</span>
                                    <small>{{ currency('name') }}</small>
                                </h5>
                                <p class="m-0 p-0">{{ $transfer->type }}</p>
                                <small class="float-right">
                                    Date: {{ date('dS M,Y', strtotime($transfer->created_at)) }} </small>
                                <h5>Beneficiary information's</h5>
                                @if ($transfer->type == 'Electronic Transfer')
                                    <dl class="row">
                                        <dt class="col-sm-3">{{ $transfer->withdrawal_method }}:</dt>
                                        <dd class="col-sm-9">{{ $transfer->beneficiary }}</dd>
                                    </dl>
                                @else
                                    <dl class="row">
                                        <dt class="col-sm-3">Bank name:</dt>
                                        <dd class="col-sm-9">{{ $transfer->bank_name }}</dd>
                                        <dt class="col-sm-3">Account name:</dt>
                                        <dd class="col-sm-9">{{ $transfer->account_name }}</dd>
                                        <dt class="col-sm-3">Account number:</dt>
                                        <dd class="col-sm-9">{{ $transfer->account_number }}</dd>
                                    </dl>
                                @endif

                            </div>
                            <div class="card-footer">
                                @if (@$settings->pdf_status == 'enabled')
                                    <div class="d-flex justify-content-between">
                                        <a href="{{ route('user.transfer.print', $transfer->reference_id) }}"
                                            class="btn btn-success btn-sm">PRINT</a>
                                    </div>
                                @endif

                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.user.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
