@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-header">
                                <h4>{{ $title }}</h4>
                                <p>Transfer history</p>
                            </div>
                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    @forelse ($transfers as $transfer)
                                        <a href="@if ($transfer->status == 0) {{ route('user.transfer.preview', $transfer->reference_id) }}
                                        @else
                                        {{ route('user.transfer.show', $transfer->reference_id) }} @endif"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            @if ($transfer->status == 0)
                                                <span class="badge badge-danger float-right">PENDING</span>
                                            @elseif($transfer->status == 1)
                                                <span class="badge badge-success float-right">APPROVED</span>
                                            @elseif($transfer->status == 2)
                                                <span class="badge badge-danger float-right">FAILED</span>
                                            @endif
                                            <h5 class="m-0 p-0"><span
                                                    class="">{{ formatAmount($transfer->amount, 'code') }}</span>
                                                <small>{{ currency('name') }}</small>
                                            </h5>
                                            <p class="m-0 p-0">{{ $transfer->transfer_type }}</p>
                                            <small class="float-right">
                                                Date: {{ date('dS M,Y', strtotime($transfer->created_at)) }} </small>
                                        </a>
                                    @empty
                                        <div class="alert alert-warning" role="alert">
                                            <strong>No transfers yet</strong>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                            @include('dashboard.user.partials.card-footer')
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.user.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
