@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-header">
                                <h4>Transaction details</h4>
                                <p>Transaction information</p>
                            </div>
                            <div class="card-body">
                                <span class="badge badge-info float-right">{{ $transaction->transaction_type }}</span>
                                <h5 class="m-0 p-0"><span
                                        class="text-primary">{{ formatAmount($transaction->amount, 'code', $user->id) }}</span>
                                    <small>{{ currency('name') }}</small>
                                </h5>
                                <p class="m-0 p-0">Description:{{ $transaction->description }}</p>
                                <small class="float-right">
                                    Date: {{ date('dS M,Y', strtotime($transaction->transaction_date)) }} </small>
                            </div>
                            <div class="card-footer">
                                @if (@$settings->pdf_status == 'enabled')
                                    <div class="d-flex justify-content-between">
                                        <a href="{{ route('user.transactions.print', $transaction->id) }}"
                                            class="btn btn-sm btn-success" target="_blank">Print <i
                                                class="fa fa-print"></i></a>
                                    </div>
                                @endif

                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.user.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
