@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-header">
                                <h4>User transactions</h4>
                                <p>Transaction history</p>
                            </div>

                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    @forelse ($transactions as $transaction)
                                        <a href="{{ route('user.transactions.show', $transaction->id) }}"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <span
                                                class="badge {{ $transaction->transaction_type == 'CREDIT' ? 'badge-success' : 'badge-danger' }} float-right">{{ $transaction->transaction_type }}</span>
                                            <h5 class="m-0 p-0"><span
                                                    class="{{ $transaction->transaction_type == 'CREDIT' ? 'text-success' : 'text-danger' }}">{{ formatAmount($transaction->amount, 'code', $user->id) }}</span>
                                                <small>{{ currency('name') }}</small>
                                            </h5>
                                            <p class="m-0 p-0">{{ $transaction->description }}</p>
                                            <p class="text-primary">Balance:
                                                {{ formatAmount($transaction->current_balance, 'code', $user->id) }}</p>
                                            <small class="float-right">
                                                Date: {{ date('dS M, Y', strtotime($transaction->transaction_date)) }}
                                            </small>
                                        </a>
                                    @empty
                                        <div class="card-body scroll-card-body">
                                            <div class="alert alert-warning" role="alert">
                                                <strong>No transactions yet</strong>
                                            </div>
                                        </div>
                                    @endforelse

                                </div>
                            </div>
                            @include('dashboard.user.partials.card-footer')
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.user.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
