@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="card-header">
                                <h4>
                                    Choose Payment Method For <span class="text-primary">{{ $planCategory->name }}</span>
                                    Plan
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-12 col-md-12">
                                        <div class="row">
                                            @forelse ($wallets as $wallet)
                                                <div class="col-sm-12 col-md-6 col-lg-3">
                                                    <a
                                                        href="{{ route('user.plans.payment.method.details', [$planCategory->slug, $wallet->acronyms]) }}"><img
                                                            src="{{ asset('uploads/wallets/logos/' . $wallet->logo) }}"
                                                            alt="" class="img-fluid w-75">
                                                        <p>{{ $wallet->name }}</p>
                                                    </a>
                                                </div>
                                            @empty
                                                <div class="alert alert-warning col-12" role="alert">
                                                    No wallet available yet
                                                </div>
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @include('dashboard.user.partials.card-footer')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
