@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="row">
                                @foreach ($planCategories as $key => $planCategory)
                                    <div class="col-sm-12 col-md-6 col-lg-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <h3>{{ $planCategory->name }}</h3>
                                                <h2 class="my-4">
                                                    <b>{{ AdminFormatAmount($settings, $planCategory->price) }}</b>
                                                </h2>

                                                <ul class="p-0 mb-0 list-unstyled">
                                                    @foreach ($planCategory->plans as $key => $plan)
                                                        <li>
                                                            <p class="mb-4"><svg width="8" class="me-2"
                                                                    viewBox="0 0 8 8" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <circle cx="4" cy="4" r="4"
                                                                        fill="currentColor"></circle>
                                                                </svg>{{ $plan->name }}</p>
                                                        </li>
                                                    @endforeach

                                                </ul>
                                                @php
                                                    $userPlan = \App\Models\UserPlan::where('user_id', Auth::user()->id)
                                                        ->where('plan_category_id', $planCategory->id)
                                                        ->first();
                                                @endphp
                                                @if ($userPlan)
                                                    @if ($userPlan->status == 1)
                                                        <button class="btn btn-success">
                                                            Activated
                                                        </button>
                                                    @else
                                                        <button class="btn btn-warning">
                                                            Pending
                                                        </button>
                                                    @endif
                                                @else
                                                    <a href="{{ route('user.plans.payment.method', $planCategory->slug) }}"
                                                        class="btn btn-primary">Choose</a>
                                                @endif

                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="card-footer" style="overflow: hidden;">
                                <div class="d-block" style="overflow: hidden;">
                                    <script type="text/javascript" src="https://widget.coinlore.com/widgets/ticker-widget.js"></script>
                                    <div class="coinlore-priceticker-widget" data-mcurrency="NRA" data-bcolor="#04081a"
                                        data-scolor="#333" data-ccolor="#428bca" data-pcolor="#428bca"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
