@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">

                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    @forelse ($notifications as $notification)
                                        <a href="#" class="list-group-item list-group-item-action list-group-item-info">
                                            <p class="m-0 p-0">{{ $notification->notification_type }}</p>
                                            <small>{{ $notification->notification }}</small>
                                            <small class="float-right">
                                                Date: {{ date('dS M,Y', strtotime($notification->created_at)) }} </small>
                                            <br>
                                        </a>
                                    @empty
                                        <div class="card-body scroll-card-body">
                                            <div class="alert alert-warning" role="alert">
                                                <strong>No notifications yet</strong>
                                            </div>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                            <div class="card-footer">
                                <h5>Total: {{ count($notifications) }}</h5>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.user.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
