@extends('dashboard.user.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.user.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.user.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-12">
                            <div class="card-header">
                                <h4>Deposit funds</h4>
                                <p>Select one of the options to deposit funds to your account</p>
                            </div>
                            <div class="card-body">
                                <div class="row">

                                    <div class="col-sm-12 col-md-5">
                                        <h4>Deposit via:</h4>
                                        <div class="row">
                                            @forelse ($wallets as $wallet)
                                                <div class="col-6">
                                                    <a href="{{ route('user.deposits.show', $wallet->acronyms) }}"><img
                                                            src="{{ asset('uploads/wallets/logos/' . $wallet->logo) }}"
                                                            alt="" class="img-fluid w-75">
                                                        <p>{{ $wallet->name }}</p>
                                                    </a>
                                                </div>
                                            @empty
                                                <div class="alert alert-warning col-12" role="alert">
                                                    No wallet available yet
                                                </div>
                                            @endforelse
                                        </div>
                                    </div>

                                    <div class="col-sm-12 col-md-7 scroll-card-body">
                                        <h5>Deposit history</h5>
                                        <ul class="list-group">
                                            @forelse ($deposits as $deposit)
                                                <a href="#"
                                                    class="list-group-item list-group-item-action {{ $deposit->status != 1 ? 'text-danger' : 'text-success' }}">
                                                    <span
                                                        class="badge {{ $deposit->status != 1 ? 'bg-danger' : 'bg-success' }} text-white float-right">{{ $deposit->status != 1 ? 'PENDING' : 'CONFIRMED' }}</span>
                                                    <h5 class="m-0 p-0">
                                                        <span
                                                            class="{{ $deposit->status != 1 ? 'text-danger' : 'text-success' }} ">
                                                            {{ formatAmount($deposit->amount, 'code', $user->id) }}
                                                            <small>{{ currency('name', $user->id) }}</small>
                                                    </h5>
                                                    <p class="m-0 p-0">
                                                        Deposited with {{ $deposit->method }} <br>
                                                        Transaction ID: {{ $deposit->reference_id }} </p>
                                                    <small class="float-right">
                                                        Date: {{ date('dS M,Y', strtotime($deposit->created_at)) }}
                                                    </small>
                                                </a>
                                            @empty
                                                <div class="col-sm-12 col-md-7 scroll-card-body">
                                                    <div class="alert alert-warning" role="alert">
                                                        No deposit record found
                                                    </div>
                                                </div>
                                            @endforelse

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @include('dashboard.user.partials.card-footer')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
