@extends('dashboard.master.layouts.master')
@section('content')
    <section class="section">
        <div class="section-header">
            <h1>{{ $title }}</h1>
        </div>
        <div class="row">
            <div class="col-12">
                @include('partials.validation-message')
                <div class="card border">
                    <div class="card-body">
                        <form action="{{ route('master.general-settings.update', 1) }}" method="post"
                            enctype="multipart/form-data">
                            @csrf
                            @method('put')
                            <div class="form-group">
                                <label for="site_name">Site Name</label>
                                <input id="site_name" type="text" class="form-control" name="site_name"
                                    value="{{ @$generalSetting->site_name }}">
                            </div>
                            <div class="form-group">
                                <label for="site_status">Site Status</label>
                                <select name="site_status" id="site_status" class="form-control">
                                    <option value="">Select</option>
                                    <option value="disabled"
                                        {{ @$generalSetting->site_status == 'disabled' ? 'selected' : '' }}>
                                        Disabled
                                    </option>
                                    <option value="enabled"
                                        {{ @$generalSetting->site_status == 'enabled' ? 'selected' : '' }}>
                                        Enabled
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="pdf_status">Pdf Status</label>
                                <select name="pdf_status" id="pdf_status" class="form-control">
                                    <option value="">Select</option>
                                    <option value="disabled"
                                        {{ @$generalSetting->pdf_status == 'disabled' ? 'selected' : '' }}>
                                        Disabled
                                    </option>
                                    <option value="enabled"
                                        {{ @$generalSetting->pdf_status == 'enabled' ? 'selected' : '' }}>
                                        Enabled
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="contact_email">Contact Email</label>
                                <input type="email" name="contact_email" id="contact_email" class="form-control"
                                    value="{{ @$generalSetting->contact_email }}">
                            </div>
                            <div class="form-group">
                                <label for="contact_phone">Contact Phone</label>
                                <input type="phone" name="contact_phone" id="contact_phone" class="form-control"
                                    value="{{ @$generalSetting->contact_phone }}">
                            </div>
                            <div class="form-group">
                                <label for="contact_address">Contact Address</label>
                                <input type="address" name="contact_address" id="contact_address" class="form-control"
                                    value="{{ @$generalSetting->contact_address }}">
                            </div>
                            <div class="form-group">
                                <label for="currency_name">Currency Name</label>
                                <select name="currency_name" id="currency_name" class="form-control select2">
                                    <option value="">Select</option>
                                    @foreach (config('setting.currency') as $key => $currency)
                                        <option value="{{ $currency['name'] }}"
                                            {{ $currency['name'] == @$generalSetting->currency_name ? 'selected' : '' }}>
                                            {{ $currency['name'] }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="currency_icon">Currency Icon</label>
                                <select name="currency_icon" id="currency_icon" class="form-control select2">
                                    <option value="">Select</option>
                                    @foreach (config('setting.currency') as $key => $currency)
                                        <option value="{{ $currency['symbol'] }}"
                                            {{ $currency['symbol'] == @$generalSetting->currency_icon ? 'selected' : '' }}>
                                            {{ $currency['name'] }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="timezone">Time Zone</label>
                                <select name="timezone" id="timezone" class="form-control select2">
                                    <option value="">Select</option>
                                    @foreach (config('setting.timezone') as $key => $timezone)
                                        <option value="{{ $key }}"
                                            {{ $key == @$generalSetting->timezone ? 'selected' : '' }}>{{ $key }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="site_environment">Site Environment</label>
                                <select name="site_environment" id="site_environment" class="form-control">
                                    <option value="">Select</option>
                                    <option value="local"
                                        {{ @$generalSetting->site_environment == 'local' ? 'selected' : '' }}>Local
                                    </option>
                                    <option value="production"
                                        {{ @$generalSetting->site_environment == 'production' ? 'selected' : '' }}>
                                        Production
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="site_debug">Site Debug</label>
                                <select name="site_debug" id="site_debug" class="form-control">
                                    <option value="">Select</option>
                                    <option value="1" {{ @$generalSetting->site_debug == 1 ? 'selected' : '' }}>True
                                    </option>
                                    <option value="0" {{ @$generalSetting->site_debug == 0 ? 'selected' : '' }}>False
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="site_url">Site Url</label>
                                <input type="address" name="site_url" id="site_url" class="form-control"
                                    value="{{ @$generalSetting->site_url }}">
                            </div>
                            <div class="form-group">
                                <label for="site_logo">Site Logo</label>
                                <input type="file" name="site_logo" id="site_logo" class="form-control">
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
