@extends('dashboard.master.layouts.master')
@section('content')
    <section class="section">
        <div class="section-header">
            <h1>{{ $title }}</h1>
        </div>
        <div class="row">
            <div class="col-12">
                @include('partials.validation-message')
                <div class="card border">
                    <div class="card-body">
                        <form action="{{ route('master.email-settings.update', 1) }}" method="post">
                            @csrf
                            @method('put')
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input id="email" type="text" class="form-control" name="email"
                                    value="{{ @$emailSetting->email }}">
                            </div>
                            <div class="form-group">
                                <label for="host">Mail host</label>
                                <input id="host" type="text" class="form-control" name="host"
                                    value="{{ @$emailSetting->host }}">
                            </div>
                            <div class="form-group">
                                <label for="username">Smtp username</label>
                                <input id="username" type="text" class="form-control" name="username"
                                    value="{{ @$emailSetting->username }}">
                            </div>
                            <div class="form-group">
                                <label for="password">Smtp password</label>
                                <input id="password" type="text" class="form-control" name="password"
                                    value="{{ @$emailSetting->password }}">
                            </div>
                            <div class="form-group">
                                <label for="port">Mail port</label>
                                <input id="port" type="text" class="form-control" name="port"
                                    value="{{ @$emailSetting->port }}">
                            </div>
                            <div class="form-group">
                                <label for="encryption">Mail encryption</label>
                                <select name="encryption" id="encryption" class="form-control">
                                    <option value="">Select</option>
                                    <option value="tls" {{ @$emailSetting->encryption == 'tls' ? 'selected' : '' }}>TLS
                                    </option>
                                    <option value="ssl" {{ @$emailSetting->encryption == 'ssl' ? 'selected' : '' }}>SSL
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
