@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <div class="card-header py-3 d-flex justify-content-between">
                        <div>
                            <h4 class="m-0  font-weight-bold text-primary">{{ $title }}</h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    <dl>
                                        <dt class="mt-0 mb-0 col-12">Wallet ID:</dt>
                                        <dd class="mt-0 mb-0 col-12">{{ $wallet->id }}</dd>
                                        <dt class="mt-0 mb-0 col-12">Wallet name:</dt>
                                        <dd class="mt-0 mb-0 col-12">{{ $wallet->name }}</dd>
                                        <dt class="mt-0 mb-0 col-12">Wallet acronym:</dt>
                                        <dd class="mt-0 mb-0 col-12">{{ $wallet->acronyms }}</dd>
                                        <dt class="mt-0 mb-0 col-12">Wallet address:</dt>
                                        <dd class="mt-0 mb-0 col-12">{{ $wallet->address }}</dd>
                                        <dt class="mt-0 mb-0 col-12">Wallet logo:</dt>
                                        <dd class="mt-0 mb-0 col-12"><img
                                                src="{{ asset('uploads/wallets/logos/' . $wallet->logo) }}"
                                                alt="{{ $wallet->name }}" class="img-flud">
                                        </dd>
                                        <dt class="mt-0 mb-0 col-12">Wallet qr code:</dt>
                                        <dd class="mt-0 mb-0 col-12"><img
                                                src="{{ asset('uploads/wallets/qr_codes/' . $wallet->qr_code) }}"
                                                alt="{{ $wallet->name }}" class="img-flud">
                                        </dd>
                                    </dl>

                                </div>

                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
