@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <div class="card-header py-3 d-flex justify-content-between">
                        <div>
                            <h4 class="m-0  font-weight-bold text-primary">{{ $title }}</h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                @forelse ($wallets as $wallet)
                                    <div class="list-group">
                                        <a href="#"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <h5 class="m-0 p-0 d-flex justify-content-between">
                                                <span>{{ $wallet->name }}</span>
                                                <small>{{ $wallet->address }}</small>
                                                @if ($wallet->status == 1)
                                                    <span class="badge badge-success float-right">Active</span>
                                                @else
                                                    <span class="badge badge-danger float-right">Inactive</span>
                                                @endif
                                            </h5>
                                            <p class="m-0 p-0">

                                            </p>
                                        </a>
                                        <div class="btn-group">
                                            <a href="{{ route('admin.wallets.show', $wallet->id) }}"
                                                class="btn text-white btn-warning btn-sm">VIEW
                                                <i class="fa fa-eye" aria-hidden="true"></i>
                                            </a>
                                            <a href="{{ route('admin.wallets.edit', $wallet->id) }}"
                                                class="btn text-white btn-primary btn-sm">EDIT
                                                <i class="fa fa-edit" aria-hidden="true"></i>
                                            </a>
                                            <a href="{{ route('admin.wallets.delete', $wallet->id) }}"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE <i class="fa fa-trash"
                                                    aria-hidden="true"></i> </a>
                                        </div>
                                        <hr>
                                    </div>
                                @empty
                                    <div class="alert alert-warning" role="alert">
                                        <strong>No wallets yet</strong>
                                    </div>
                                @endforelse
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('partials.validation-message')
                            @include('partials.email-message')
                            <div class="card">

                                <div class="card-header">
                                    <h5>Create wallet</h5>
                                </div>
                                <div class="card-body">
                                    <small id="helpId" class="text-danger">This wallet will be used by the user for
                                        deposit.</small>
                                    <form action="{{ route('admin.wallets.store') }}" method="POST" class="row"
                                        enctype="multipart/form-data">
                                        @csrf
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="name">Name </label>
                                                <input type="text" name="name" id="name"
                                                    value="{{ old('name') }}" class="form-control"
                                                    placeholder="Enter wallet name" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="acronyms">Acronyms </label>
                                                <input type="text" name="acronyms" id="acronyms"
                                                    value="{{ old('acronyms') }}" class="form-control"
                                                    placeholder="Enter wallet acronyms" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="address">Address </label>
                                                <input type="text" name="address" id="address"
                                                    value="{{ old('address') }}" class="form-control"
                                                    placeholder="Enter wallet address" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="logo">Logo </label>
                                                <input type="file" name="logo" id="logo" class="form-control"
                                                    aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="qr_code">Qr code </label>
                                                <input type="file" name="qr_code" id="qr_code" class="form-control"
                                                    aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="status">Status </label>
                                                <select name="status" id="status" class="form-control" required>
                                                    <option value="">Select status of the wallet</option>
                                                    <option value="1">Active</option>
                                                    <option value="0">Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">SUBMIT</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
