@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <div class="card-header py-3 d-flex justify-content-between">
                        <div>
                            <h4 class="m-0  font-weight-bold text-primary">{{ $title }}</h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-8">
                            <ul class="list-group">
                                @forelse ($verificationCodes as $code)
                                    <div class="list-group-item mb-2">
                                        <h5 class="d-flex justify-content-between"> {{ $code->name }} <div
                                                class="dropdown open">
                                                <button class="btn btn-primary btn-sm dropdown-toggle" type="button"
                                                    data-bs-toggle="dropdown">
                                                    <i class="fa fa-cog" aria-hidden="true"></i> Actions
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="triggerId">
                                                    <a class="dropdown-item"
                                                        href="{{ route('admin.verification-codes.edit', $code->id) }}">Edit
                                                    </a>
                                                    <a class="dropdown-item"
                                                        href="{{ route('admin.verification-codes.delete', $code->id) }}"
                                                        onclick="return confirm('Are you sure?')">Delete
                                                        code</a>
                                                </div>
                                            </div>
                                        </h5>
                                        <p>Applicable for:
                                            @if ($code->applicable_to == 'All')
                                                {{ $code->applicable_to }} users
                                            @else
                                                {{ $code->user->name }}
                                            @endif
                                        </p>
                                        <small>Nature : {{ $code->length }} <span
                                                class="text-capitalize">{{ $code->nature_of_code }}</span> code</small>
                                        <span class="badge badge-primary float-right">{{ $code->created_at }}</span>

                                    </div>
                                @empty
                                    <div class="alert alert-warning">No verification code registered</div>
                                @endforelse
                            </ul>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            <form action="{{ route('admin.verification-codes.update', $verificationCode->id) }}"
                                class="row" method="POST">
                                @csrf
                                @method('patch')
                                <div class="col-xs-12 col-md-12">
                                    @include('partials.validation-message')
                                    <h4>Edit verification code</h4>
                                    <div class="form-group">
                                        <label for="">Name</label>
                                        <input type="text" name="name" id="name" class="form-control"
                                            value="{{ $verificationCode->name }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="">Description</label>
                                        <input type="text" name="description" class="form-control"
                                            value="{{ $verificationCode->description }}">
                                        <small>What this code is all about</small>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Length</label>
                                        <input type="number" name="length" value="{{ $verificationCode->length }}"
                                            class="form-control">
                                        <small>How long do you want this code to be when generated?</small>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Nature of code</label>
                                        <select name="nature_of_code" class="form-control">
                                            <option value="alnum"
                                                {{ $verificationCode->nature_of_code == 'alnum' ? 'selected' : '' }}>
                                                Alphanumeric</option>
                                            <option value="numeric"
                                                {{ $verificationCode->nature_of_code == 'numeric' ? 'selected' : '' }}>
                                                Numeric</option>
                                        </select>
                                        <small>Do you want this code to be a mixture of letters and numbers(alpha-numeric)?
                                            or
                                            just
                                            numbers(numeric)</small>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Applicable to user</label>
                                        <select name="applicable_to" class="form-control">
                                            <option {{ $verificationCode->applicable_to == 'All' ? 'selected' : '' }}
                                                value="All">
                                                ALL USERS</option>
                                            @foreach ($users as $user)
                                                <option
                                                    {{ $verificationCode->applicable_to == $user->id ? 'selected' : '' }}
                                                    value="{{ $user->id }}">
                                                    {{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button class="btn btn-primary btn-sm" type="submit">
                                            UPDATE
                                        </button>
                                        <button class="btn btn-warning btn-sm" type="reset">
                                            RESET
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
