@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.admin.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body">
                                <div class="list-group ">
                                    @forelse ($transfers as $transfer)
                                        <a href="{{ route('admin.users.withdrawals.show', [$user->id, $transfer->reference_id]) }}"
                                            class="list-group-item list-group-item-action list-group-item-secondary">
                                            <p class="m-0 p-0"><?= $transfer->type ?></p>
                                            <small>Amount:
                                                <?= formatAmount($transfer->amount, 'code', $user->id) ?></small>
                                            <small class="float-right">
                                                Date: <?= date('dS M,Y', strtotime($transfer->created_at)) ?> </small>
                                        </a>
                                        <div class="mb-3 bg-primary d-flex justify-content-between p-1 text-white hide-sm">
                                            <span>
                                                <i class="fa fa-info-circle" aria-hidden="true"></i>
                                                <?= $transfer->reference_id ?> </span>
                                            <a href="{{ route('admin.users.withdrawals.delete', $transfer->id) }}"
                                                class="btn btn-danger btn-sm"
                                                onclick="return confirm('Are you sure?')">DELETE</a>
                                        </div>
                                    @empty
                                        <div class="alert alert-warning">No withdrawals yet</div>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.admin.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
