@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.admin.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                @forelse ($transactions as $transaction)
                                    <div class="list-group">
                                        <a href="#"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <h5 class="m-0 p-0 d-flex justify-content-between">
                                                @if ($transaction->transaction_type == 'CREDIT')
                                                    <span
                                                        class="text-success">{{ formatAmount($transaction->amount, 'code', $user->id) }}</span>
                                                @elseif ($transaction->transaction_type == 'DEBIT')
                                                    <span
                                                        class="text-danger">{{ formatAmount($transaction->amount, 'code', $user->id) }}</span>
                                                @endif
                                                <small>{{ $transaction->currency }}</small>

                                                @if ($transaction->transaction_type == 'CREDIT')
                                                    <span class="badge badge-success float-right">CREDIT</span>
                                                @elseif($transaction->transaction_type == 'DEBIT')
                                                    <span class="badge badge-danger float-right">DEBIT</span>
                                                @endif
                                            </h5>
                                            <p class="m-0 p-0">{{ $transaction->description }}</p>
                                            <small>Balance:
                                                {{ formatAmount($transaction->current_balance, 'code', $user->id) }}</small>
                                            <small class="float-right">
                                                Date: {{ date('dS M, Y', strtotime($transaction->transaction_date)) }}
                                            </small>
                                        </a>
                                        <div class="btn-group">
                                            @if (@$settings->pdf_status == 'enabled')
                                                <a href="{{ route('admin.users.transactions.print', [$user->id, $transaction->id]) }}"
                                                    class="btn text-white btn-primary btn-sm" target="_blank">PRINT <i
                                                        class="fa fa-print" aria-hidden="true"></i>
                                                </a>
                                            @endif
                                            <a href="{{ route('admin.users.transactions.delete', $transaction->id) }}"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE <i class="fa fa-trash"
                                                    aria-hidden="true"></i> </a>
                                        </div>
                                        <hr>
                                    </div>
                                @empty
                                    <div class="alert alert-warning" role="alert">
                                        <strong>No transactions yet</strong>
                                    </div>
                                @endforelse
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('partials.validation-message')
                            @include('partials.email-message')
                            <div class="card">

                                <div class="card-header">
                                    <h5>Send Transaction</h5>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="mt-0 mb-0 col-sm-4">Account name:</dt>
                                        <dd class="mt-0 mb-0 col-sm-8"><?= $user->name ?></dd>
                                        <dt class="mt-0 mb-0 col-sm-4">Account balance:</dt>
                                        <dd class="mt-0 mb-0 col-sm-8">
                                            <strong>{{ formatAmount($user->balance, 'code', $user->id) }}</strong>
                                            -
                                            {{ currency('name', $user->id) }}
                                        </dd>
                                    </dl>
                                    <small id="helpId" class="text-danger">Do not use: spaces or comma, use only numbers
                                        when
                                        entering amount</small>
                                    <form action="{{ route('admin.users.transactions.store', $user->id) }}" method="POST"
                                        class="row">
                                        @csrf
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Amount </label>
                                                <input type="text" name="amount" id="" required=""
                                                    value="" class="form-control" placeholder=""
                                                    aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Type </label>
                                                <select name="type" id="" class="form-control" required="">
                                                    <option value=""></option>
                                                    <option value="DEBIT">DEBIT</option>
                                                    <option value="CREDIT">CREDIT</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Date</label>
                                                <input type="date" name="date" id="" required=""
                                                    class="form-control" placeholder="" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-6">
                                            <div class="form-group">
                                                <label for="">Notification </label>
                                                <select name="notification" id="" class="form-control"
                                                    required="">
                                                    <option value=""></option>
                                                    <option value="NONE">NONE</option>
                                                    <option value="EMAIL">EMAIL</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label for="">Description</label>
                                                <input type="text" name="description" required="" id=""
                                                    class="form-control" placeholder="" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">SUBMIT</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
