@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.admin.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">

                                <div class="list-group">
                                    <dl>
                                        <dt>Reference ID:</dt>
                                        <dd>{{ $userPlan->reference_id }}</dd>

                                        <dt>Amount:</dt>
                                        <dd>{{ formatAmount($userPlan->amount, 'code', $user->id) }}</dd>

                                        <dt>Payment method:</dt>
                                        <dd>{{ $userPlan->method }}</dd>

                                        <dt>Status:</dt>
                                        <dd>
                                            @if ($userPlan->status == 1)
                                                Confirmed
                                            @else
                                                Pending
                                            @endif
                                        </dd>

                                        <dt>Payment proof:</dt>
                                        <dd>
                                            <img src="{{ asset('uploads/plan/proofs/' . $userPlan->proof) }}"
                                                alt="{{ $userPlan->reference_id }}">
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.admin.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
