@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.admin.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                <div class="list-group">
                                    <dl>
                                        <dt>Reference ID:</dt>
                                        <dd>{{ $userPlan->reference_id }}</dd>

                                        <dt>Amount:</dt>
                                        <dd>{{ formatAmount($userPlan->amount, 'code', $user->id) }}</dd>

                                        <dt>Payment method:</dt>
                                        <dd>{{ $userPlan->method }}</dd>

                                        <dt>Status:</dt>
                                        <dd>
                                            @if ($userPlan->status == 1)
                                                Confirmed
                                            @else
                                                Pending
                                            @endif
                                        </dd>
                                    </dl>
                                </div>
                                <hr>
                                <form action="{{ route('admin.users.plans.confirm.store', [$user->id, $userPlan->id]) }}"
                                    method="post">
                                    @csrf
                                    <div class="form-group">
                                        <label for="earning">User earning</label>
                                        <input type="number" name="earning" id="earning" class="form-control">
                                        <code> Amount the user earned </code>
                                    </div>
                                    <button type="submit" class="btn btn-primary">Confirm</button>
                                </form>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.admin.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
