@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content mt-5">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                @include('partials.validation-message')
                @include('partials.email-message')
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.admin.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-8">
                            <div class="card-body scroll-card-body">

                                <div class="list-group">
                                    @forelse ($notifications as $notification)
                                        <a href="#" class="list-group-item list-group-item-action list-group-item-info">
                                            <p class="m-0 p-0"><?= $notification->notification_type ?></p>
                                            <small><?= $notification->notification ?></small>
                                            <small class="float-right">
                                                Date: <?= date('dS M,Y', strtotime($notification->created_at)) ?> </small>
                                            <br>
                                        </a>
                                        <small class="bg-gradient-light p-1 text-primary m-0"> <i class="fa fa-bell"
                                                aria-hidden="true"></i> Email sent successfully
                                            to:<?= $user->email ?></small>
                                        <div class="btn-group mb-2 mt-0">
                                            <a href="{{ route('admin.users.notifications.delete', $notification->id) }}"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE <i class="fa fa-trash"
                                                    aria-hidden="true"></i> </a>
                                        </div>
                                    @empty
                                        <div class="alert alert-warning">No notification yet</div>
                                    @endforelse
                                </div>
                            </div>
                            <div class="card-footer">
                                <button class="btn-primary btn btn-sm" data-bs-toggle="modal" data-bs-target="#modelId">Send
                                    notification <i class="fa fa-bell" aria-hidden="true"></i> </button>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-4">
                            @include('dashboard.admin.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="modelId" tabindex="-1" aria-labelledby="modelTitleId" style="display: none;"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <form action="{{ route('admin.users.notifications.store', $user->id) }}" method="POST">
                        @csrf
                        <div class="modal-header">
                            <h5 class="modal-title">Send notification</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="">Title</label>
                                <input type="text" name="title" id="" class="form-control"
                                    placeholder="Enter notification title" aria-describedby="helpId">
                            </div>
                            <div class="form-group">
                                <label for="">Message</label>
                                <input type="text" name="message" id="" class="form-control"
                                    placeholder="Enter notification message" aria-describedby="helpId">
                            </div>
                            <div class="form-group">
                                <label for="">Notification</label>
                                <select name="notifiable" class="form-control" id="">
                                    <option value="NONE">NONE</option>
                                    <option value="EMAIL">EMAIL</option>
                                </select>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary btn-sm">Send</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </section>
    <!-- /.content -->
@endsection
