@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.admin.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">

                                <div class="list-group">
                                    <dl>
                                        <dt>Reference ID:</dt>
                                        <dd>{{ $deposit->reference_id }}</dd>

                                        <dt>Amount:</dt>
                                        <dd>{{ formatAmount($deposit->amount, 'code', $user->id) }}</dd>

                                        <dt>Deposit method:</dt>
                                        <dd>{{ $deposit->method }}</dd>

                                        <dt>Status:</dt>
                                        <dd>
                                            @if ($deposit->status == 1)
                                                Confirmed
                                            @else
                                                Pending
                                            @endif
                                        </dd>

                                        <dt>Deposit proof:</dt>
                                        <dd>
                                            <img src="{{ asset('uploads/deposits/proofs/' . $deposit->proof) }}"
                                                alt="{{ $deposit->reference_id }}">
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.admin.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
