@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    @include('dashboard.admin.partials.card-header')
                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">

                                <div class="list-group">
                                    @forelse($deposits as $deposit)
                                        <a href="{{ route('admin.users.deposits.show', [$user->id, $deposit->id]) }}"
                                            class="list-group-item list-group-item-action list-group-item-{{ $deposit->status == 1 ? 'success' : 'danger' }}">
                                            <dl class="row">
                                                <dt class="col-sm-4 m-0">Date:</dt>
                                                <dd class="col-sm-8 m-0"><i class="fa fa-calendar" aria-hidden="true"></i>
                                                    {{ date('dS M Y', strtotime($deposit->created_at)) }}
                                                </dd>
                                                <dt class="col-sm-4 m-0">Amount:</dt>
                                                <dd class="col-sm-8 m-0">
                                                    {{ formatAmount($deposit->amount, 'code', $user->id) }}
                                                    {{ $deposit->currency }}</dd>
                                                <dt class="col-sm-4 m-0">Status:
                                                </dt>
                                                <dd class="col-sm-8 m-0">
                                                    {{ $deposit->status == 1 ? 'CONFIRMED' : 'PENDING' }}
                                                </dd>
                                                <dt class="col-sm-4 m-0">Transaction ID:
                                                </dt>
                                                <dd class="col-sm-8 m-0">{{ $deposit->reference_id }}</dd>
                                            </dl>
                                        </a>
                                        <div class="btn-group mb-1">
                                            @if ($deposit->status == 0)
                                                <a href="{{ route('admin.users.deposits.confirm', [$user->id, $deposit->id]) }}"
                                                    class="btn text-white btn-info btn-sm"
                                                    title="Click to confirm transaction">CONFIRM
                                                    <i class="fa fa-envelope" aria-hidden="true"></i> </a>
                                            @endif
                                            <a href="{{ route('admin.users.deposits.delete', $deposit->id) }}"
                                                title="Click to delete transaction"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE
                                                <i class="fa fa-trash" aria-hidden="true"></i> </a>
                                        </div>
                                    @empty
                                        <div class="alert alert-warning">No deposit record yet</div>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('dashboard.admin.partials.personal-account-details')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
