@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-8">
                <div class="card shadow mb-4 border-left-danger ">
                    @include('dashboard.admin.partials.card-header')
                    <div class="card-body">
                        <form action="{{ route('admin.users.account-settings.update', $user->id) }}" method="post">
                            @csrf
                            @method('put')
                            <div class="form-group">
                                <label for="">Set state</label>
                                <select class="form-control" required name="status" id="status">
                                    <option value="">Select</option>
                                    @foreach (config('setting.user_status') as $key => $status)
                                        <option value="{{ $status }}"
                                            {{ $user->status == $status ? 'selected' : '' }}>{{ $key }}</option>
                                    @endforeach
                                </select>
                                <small id="" class="text-muted d-block">Inactive users cannot login</small>
                            </div>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
