@extends('dashboard.admin.layouts.master')
@section('content')
    <!-- Content Header (Page header) -->
    @include('dashboard.admin.partials.content-header')
    <!-- Main content -->
    <section class="content">
        <!-- Basic Card Example -->
        <div class="row">
            <div class="col-sm-12 col-md-12">
                <div class="card shadow mb-4 border-bottom-success">
                    <div class="card-header py-3 d-flex justify-content-between">
                        <div>
                            <h4 class="m-0  font-weight-bold text-primary">{{ $title }}</h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12 col-md-7">
                            <div class="card-body scroll-card-body">
                                @forelse ($planCategories as $planCategory)
                                    <div class="list-group">
                                        <a href="#"
                                            class="list-group-item list-group-item-action list-group-item-default">
                                            <h5 class="m-0 p-0 d-flex justify-content-between">
                                                <span>{{ $planCategory->name }}</span>
                                                <small>{{ adminFormatAmount($settings, $planCategory->price) }}</small>
                                            </h5>
                                        </a>
                                        <div class="btn-group">
                                            <a href="{{ route('admin.plans.index', $planCategory->slug) }}"
                                                class="btn text-white btn-warning btn-sm">ADD PLAN
                                                <i class="fa fa-plus" aria-hidden="true"></i>
                                            </a>
                                            <a href="{{ route('admin.plan-categories.edit', $planCategory->id) }}"
                                                class="btn text-white btn-primary btn-sm">EDIT
                                                <i class="fa fa-edit" aria-hidden="true"></i>
                                            </a>
                                            <a href="{{ route('admin.plan-categories.delete', $planCategory->id) }}"
                                                onclick="return confirm('Are you sure?')"
                                                class="btn text-white btn-danger btn-sm">DELETE <i class="fa fa-trash"
                                                    aria-hidden="true"></i> </a>
                                        </div>
                                        <hr>
                                    </div>
                                @empty
                                    <div class="alert alert-warning" role="alert">
                                        <strong>No plan categories yet</strong>
                                    </div>
                                @endforelse
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-5">
                            @include('partials.validation-message')
                            @include('partials.email-message')
                            <div class="card">

                                <div class="card-header">
                                    <h5>Create plan category</h5>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('admin.plan-categories.store') }}" method="POST" class="row">
                                        @csrf
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label for="name">Name </label>
                                                <input type="text" name="name" id="name"
                                                    value="{{ old('name') }}" class="form-control"
                                                    placeholder="Enter plan category name" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label for="price">Price </label>
                                                <input type="text" name="price" id="price"
                                                    value="{{ old('price') }}" class="form-control"
                                                    placeholder="Enter plan category price" aria-describedby="helpId">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">SUBMIT</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
@endsection
