<?php

namespace Database\Seeders;

use Carbon\Carbon;
use App\Models\Plan;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name'             => 'Instant Trading',
                'plan_category_id' => 1,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Demo Trading',
                'plan_category_id' => 1,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => '5 Trades/Day',
                'plan_category_id' => 1,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Leverage from 1:100',
                'plan_category_id' => 1,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Risk Management',
                'plan_category_id' => 1,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            // Plan 2
            [
                'name'             => 'Instant Trading',
                'plan_category_id' => 2,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Demo Trading',
                'plan_category_id' => 2,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Regulated Margin',
                'plan_category_id' => 2,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Leverage from 1:120',
                'plan_category_id' => 2,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Risk Management',
                'plan_category_id' => 2,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            // Plan 3
            [
                'name'             => 'Instant Trading',
                'plan_category_id' => 3,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Demo Trading',
                'plan_category_id' => 3,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Performant Margin',
                'plan_category_id' => 3,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Leverage from 1:250',
                'plan_category_id' => 3,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Minimum Risk Level',
                'plan_category_id' => 3,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            // Plan 4
            [
                'name'             => 'Instant Trading',
                'plan_category_id' => 4,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Demo Trading',
                'plan_category_id' => 4,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Unlimited Trades',
                'plan_category_id' => 4,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Leverage from 1:500',
                'plan_category_id' => 4,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => 'Zero Risk Level',
                'plan_category_id' => 4,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            // Trader Plan
            [
                'name'             => '120% Profit',
                'plan_category_id' => 5,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => '100:1 Leverage',
                'plan_category_id' => 5,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
            [
                'name'             => '5 trades per day',
                'plan_category_id' => 5,
                'created_at'       => Carbon::now(),
                'updated_at'       => Carbon::now(),
            ],
        ];
        foreach ($plans as $key => $plan) {
            Plan::create($plan);
        }
    }
}
