<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Models\PlanCategory;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PlanCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'name'       => 'Silver',
                'price'      => '5000',
                'slug'       => Str::slug('Silver'),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ],
            [
                'name'       => 'Gold Trader',
                'price'      => '20000',
                'slug'       => Str::slug('Gold Trader'),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ],
            [
                'name'       => 'Diamond Trader',
                'price'      => '50000',
                'slug'       => Str::slug('Diamond Trader'),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ],
            [
                'name'       => 'Platinum Trader',
                'price'      => '100000',
                'slug'       => Str::slug('Platinum Trader'),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ],
            [
                'name'       => 'Basic',
                'price'      => '500',
                'slug'       => Str::slug('Basic'),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ],
        ];
        foreach ($data as $key => $planCategory) {
            PlanCategory::create($planCategory);
        }
    }
}
