<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('nationality')->nullable();
            $table->string('currency')->nullable();
            $table->string('account')->nullable();
            $table->string('account_number')->nullable();
            $table->string('role')->default('user');
            $table->string('password');
            $table->string('date_of_birth')->nullable();
            $table->string('gender')->nullable();
            $table->string('marital_status')->nullable();
            $table->string('dial_code')->nullable();
            $table->string('phone')->nullable();
            $table->string('professional_status')->nullable();
            $table->string('address')->nullable();
            $table->string('state')->nullable();
            $table->string('image')->default('profile.png');
            $table->string('code')->nullable();
            $table->string('referral_code')->nullable();
            $table->string('referral')->nullable();
            $table->string('balance')->default(0);
            $table->string('earning')->default(0);
            $table->boolean('should_transfer_fail')->default(0);
            $table->boolean('status')->default(1);
            $table->dateTime('last_login_time')->default(Carbon::now());
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
