<?php

namespace App\Traits;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;

trait ImageUploadTrait
{
    public function uploadFile($request, $inputName, $path)
    {
        if ($request->hasFile($inputName)) {

            $file = $request->file($inputName);

            $fileName = time() . '_' . rand() . '.' . $file->extension();

            $file->move(public_path($path), $fileName);

            return $fileName;
        }
    }
    public function updateFile($request, $inputName, $path, $oldFile)
    {
        if ($request->hasFile($inputName)) {

            $this->deleteFile($path, $oldFile);

            $file = $request->file($inputName);

            $fileName = time() . '_' . rand() . '.' . $file->extension();

            $file->move(public_path($path), $fileName);

            return $fileName;
        }
    }
    public function deleteFile($path, $oldFile)
    {
        if (File::exists(public_path($path . $oldFile))) {

            File::delete(public_path($path . $oldFile));
        }
    }
    public function imageInterventionUploadImage($request, $inputName, $path, $width, $height)
    {
        if ($request->hasFile($inputName)) {
            $file = $request->file($inputName);

            $directory = public_path($path);

            if (!is_dir($directory)) {

                mkdir($directory, 0777, true);
            }

            $imageName = time() . '_' . rand() . '.' . $file->extension();

            $image = Image::make($file)->resize($width, $height);

            $image->save($directory . $imageName);


            return $imageName;
        }
    }
    public function imageInterventionUpdateImage($request, $inputName, $path, $width, $height, $oldImage)
    {
        if ($request->hasFile($inputName)) {
            $this->deleteFile($path, $oldImage);

            $file = $request->file($inputName);

            $directory = public_path($path);

            if (!is_dir($directory)) {
                mkdir($directory, 0777, true);
            }

            $imageName = time() . '_' . rand() . '.' . $file->extension();

            $image = Image::make($file)->resize($width, $height);

            $image->save($directory . $imageName);

            return $imageName;
        }
    }
    public function uploadMultipleImage(Request $request, $inputName, $path)
    {
        $uploadedFileName = [];
        if ($request->hasFile($inputName)) {

            $files = $request->file($inputName);

            foreach ($files as $file) {

                $fileName = time() . '_' . rand() . '.' . $file->extension();

                $file->move(public_path($path), $fileName);

                array_push($uploadedFileName, $fileName);
            }


            return $uploadedFileName;
        }
    }

    public function imageInterventionUploadMultipleImage(Request $request, $inputName, $path, $width, $height)
    {
        $uploadedFileNames = [];

        if ($request->hasFile($inputName)) {
            $files = $request->file($inputName);

            foreach ($files as $file) {
                $directory = public_path($path);

                if (!is_dir($directory)) {
                    mkdir($directory, 0777, true);
                }

                $fileName = time() . '_' . rand() . '.' . $file->extension();

                $image = Image::make($file)->resize($width, $height);

                $image->save($directory . $fileName);

                array_push($uploadedFileNames, $fileName);
            }

            return $uploadedFileNames;
        }
    }
}
