<?php

namespace App\Providers;

use App\Helper\DatabaseSettingHelper;
use App\Helper\EmailSettingHelper;
use App\Helper\GeneralSettingHelper;
use App\Models\GeneralSetting;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Model::unguard();

        EmailSettingHelper::config();

        GeneralSettingHelper::config();

        $generalSetting = GeneralSetting::first();
        // Share the general settings with all views
        // Using a view composer will allow us to inject data into all views
        // without having to do it manually in each controller
        // $view will refer to the current view being rendered
        View::composer('*', function ($view) use ($generalSetting) {
            // Inject the general setting into the view
            // Using the 'with' method will make the data available in the view
            // as a variable with the key 'setting'
            $view->with('settings', $generalSetting);
        });
    }
}
