<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class GuestMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->guard('web')->check()) {
            if ($request->user()->role === 'admin') {
                return redirect('/admin/dashboard');
            } elseif ($request->user()->role === 'user') {
                return redirect('/user/dashboard');
            } elseif ($request->user()->role === 'master') {
                return redirect('/master/dashboard');
            }
        }
        return $next($request);
    }
}
