<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Helper\UserHelper;
use App\Http\Controllers\Controller;
use App\Mail\UserEmailVerification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class VerificationController extends Controller
{
    public function verification()
    {
        $user = User::findOrFail(auth()->user()->id);
        $data = [
            'title' => 'User email verification',
            'user'  => $user
        ];

        return view('dashboard.user.verification', $data);
    }
    public function resendVerification()
    {
        $user = User::findOrFail(auth()->user()->id);

        $code = UserHelper::generateCode();

        $content = [
            'code' => $code
        ];

        $user->code = $code;
        $user->save();

        Mail::to($user->email)->send(new UserEmailVerification($user, $content, 'Verify email address'));

        return redirect()->route('user.verification')->with('success', 'Verification code sent successfully');
    }
    public function verify(Request $request)
    {
        $request->validate([
            'code' => 'required|numeric',
        ]);

        $user = User::findOrFail(auth()->user()->id);

        if ($user->code == $request->code) {
            $user->email_verified_at = Carbon::now();
            $user->save();

            return redirect()->route('user.dashboard')->with('success', 'Email verified successfully');
        } else {
            return redirect()->back()->with('error', 'Invalid verification code');
        }
    }
}
