<?php

namespace App\Http\Controllers\Dashboard\User;

use Carbon\Carbon;
use App\Models\User;
use App\Helper\UserHelper;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\GeneralSetting;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;

class TransactionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $transactions = Transaction::where('user_id', $user->id)->orderBy('id', 'desc')->take(10)->get();

        $data = [
            'title' => 'User transactions',
            'user'  => $user,
            'transactions' => $transactions,
        ];

        return view('dashboard.user.transaction.index', $data);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $transaction = Transaction::findOrFail($id);

        $data = [
            'title' => 'User transactions',
            'user'  => $user,
            'transaction' => $transaction,
        ];

        return view('dashboard.user.transaction.show', $data);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function print(string $id)
    {
        $user = User::findOrFail(auth()->user()->id);
        $transaction = Transaction::where('user_id', $user->id)->where('id', $id)->first();
        $generalSetting = GeneralSetting::first();

        $data = [
            'user'           => $user,
            'transaction'    => $transaction,
            'generalSetting' => $generalSetting
        ];

        $name = config('app.name') . '-' . 'Transaction Receipt For' . '-' . $user->name . '-' . Carbon::now();

        $pdf = Pdf::loadView('pdf.transaction', $data);

        return $pdf->download($name);
    }
}
