<?php

namespace App\Http\Controllers\Dashboard\User;

use App\Helper\UserHelper;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Traits\ImageUploadTrait;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    use ImageUploadTrait;
    public function index()
    {
        if (UserHelper::isUserEmailVerified()) {
            return redirect()->route('user.verification')->with('error', 'Unable to verify the authenticity of this account, Please enter verification code sent to your email at the time of registration');
        }

        $user = User::findOrFail(auth()->user()->id);

        $data = [
            'title' => 'User profile',
            'user' => $user
        ];

        return view('dashboard.user.profile.index', $data);
    }
    public function update(Request $request)
    {
        $credentials = $request->validate([
            'name'                  => ['nullable', 'string'],
            'email'                 => ['nullable', 'email'],
            'date_of_birth'         => ['required', 'date'],
            'gender'                => ['required', 'string'],
            'marital_status'        => ['required', 'string'],
            'dial_code'             => ['required', 'string'],
            'phone'                 => ['required', 'numeric', 'unique:users,phone,' . auth()->user()->id],
            'professional_status'   => ['required', 'string'],
            'address'               => ['required', 'string'],
            'state'                 => ['required', 'string'],
            'nationality'           => ['required', 'string'],
            'currency'              => ['required', 'string'],
            'account'               => ['nullable', 'string'],
        ]);

        $user = User::findOrFail(auth()->user()->id);
        $user->update($credentials);

        return redirect()->back()->with('success', 'Profile updated successfully');
    }
    public function imageUpdate(Request $request)
    {
        $request->validate([
            'image' => ['required', 'image', 'mimes:jpeg,png,jpg,gif,svg', 'max:2048'],
        ]);

        $user = User::findOrFail(auth()->user()->id);
        $user->image = $this->imageInterventionUpdateImage($request, 'image', 'uploads/users/images/', 500, 500, $user->image);
        $user->save();

        return redirect()->back()->with('success', 'Profile image updated successfully');
    }
}
